<?php

namespace App\Http\Repositories;

use App\Helpers\UserHelper;
use App\Models\Factory;
use App\Models\Factory_area;
use App\Models\Factory_bding;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class FactoryRepositories
{

    function __construct(protected Factory $factory, protected Factory_bding $bding, protected Factory_area $area,protected AuthRepository $auth) {}

    //取得工廠詳細資料
    public function getFactory($id)
    {
        $data = $this->factory->with(['building', 'area' => function($query) {
            $query->orderBy('id', 'desc');
        }])->where('id', $id)->first();
        if ($data && $data->area) {
            foreach ($data->area as $area) {
                $b_id = $area->b_id;
                $bd = $this->bding->where('id', $b_id)->first();
                $b_name = $bd->name ?? '';
                $relativePath = $area->pic_path;
                $area->pic_path = config('app.asset_url') . Storage::url($relativePath);
                $area['b_name'] = $b_name;
            }
        }
        return $data;
    }

    function findFactory($id){
        return $this->factory->find($id);
    }

    //顯示公司底下工廠清單
    public function getFactoryAll()
    {
        $user = Auth::user();
        $companyId = UserHelper::getCompanyId();
        
        return $this->factory->with('building', 'area')
            ->where('company_id', $companyId)
            ->get();
    }

    public function getAreaInfo($area_id)
    {
        return $this->area->join('factory_bdings as builds','builds.id','=','factory_areas.b_id')
        ->join('factories','factories.id','=','factory_areas.f_id')
        ->select('factory_areas.id as a_id','factory_areas.f_id','factory_areas.b_id','factories.name as f_name','builds.name as b_name','factory_areas.name','factory_areas.pic_path','factory_areas.floor')
        ->find($area_id);
    }

    public function getBuildInfo($build_id){
        return $this->bding->with(['area' => function ($query) {
            $query->select('id', 'floor', 'b_id')
            ->distinct('floor'); // 確保 floor 不重複
        }])->select('id','name')->find($build_id);
    }

    public function getFloorInfo($build_id,$floor){
        return $this->bding->with(['area' => function ($query)  use ($floor) {
            $query->select('id', 'floor', 'b_id','name')
            ->where('floor',$floor); // 確保 floor 不重複
        }])->select('id','name')->find($build_id);
    }

    //建立工廠
    public function factoryStore($data)
    {
        $factory = $this->factory->create($data);
        return $factory->id;
    }
    //檢查建立工廠名稱重複
    function checkFactoryName($name,$user){
        return $this->factory->where('company_id', UserHelper::getCompanyId())->where('name',$name)->first();
    }
    //檢查更新工廠名稱重複
    function checkUpdateFactoryName($name,$id,$user){
        return $this->factory->where('company_id', UserHelper::getCompanyId())->whereNot('id',$id)->where('name',$name)->first();
    }
    public function factoryUpdate($data, $id)
    {
        $update = $this->getFactory($id);
        $update->update($data);
        return $update->id;
    }
    function getBuild($id)
    {
        return $this->bding->with('area')->find($id);
    }
    public function getbding()
    {
        return $this->bding->all();
    }
    public function checkBdingName($name,$f_id){
        return $this->bding->where('f_id',$f_id)->where('name',$name)->first();
    }
    public function checkUpdateBdingName($name,$f_id,$id){
        return $this->bding->where('f_id',$f_id)->whereNot('id',$id)->where('name',$name)->first();
    }
    public function bdingStore($data)
    {
        $bding = $this->bding->create($data);
        return $bding->id;
    }
    public function bdingUpdate($data, $id)
    {
        $update = $this->bding->where('id', $id)->first();
        $update->update($data);
        return $update->f_id;
    }
    public function bdingDstory($id)
    {
        $del = $this->bding->find($id);
        $this->bding->destroy($id);
        return $del->f_id;
    }

    function getArea($id)
    {
        return $this->area->find($id);
    }
    function checkAreaName($name,$b_id){
        return $this->area->where('b_id',$b_id)->where('name',$name)->first();
    }
    function checkUpdateAreaName($name,$b_id,$id){
        return $this->area->where('b_id',$b_id)->whereNot('id',$id)->where('name',$name)->first();
    }
    public function areaStore($data)
    {
        return $this->area->create($data);
    }

    public function areaUpdate($data, $id)
    {
        $update = $this->area->where('id', $id)->first();
        $update->update($data);
        return $update->f_id;
    }

    public function areaData($id)
    {
        return $this->area->where('id', $id)->first();
    }

    public function fileUpdate($data, $id)
    {
        $update = $this->area->where('id', $id)->first();
        $update->update($data);
        return $update;
    }

    public function areaDestory($id)
    {
        $file = $this->area->find($id);
        $filePath = $file->pic_path;
        if($filePath){
            Storage::delete($filePath);
        }
        $this->area->destroy($id);
        return $file->f_id;
    }

    public function picDestory($id)
    {
        $file = $this->area->find($id);
        $filePath = $file->pic_path;
        if($filePath){
            Storage::delete($filePath);
        }
        $file->pic = '';
        $file->pic_path = '';
        $file->save();

        return $file->f_id;
    }

    public function listDestory(array $ids)
    {
        $destories = $this->getDestoryFacotry($ids);
        foreach ($destories as $destory) {
            foreach ($destory->building as $building) {
                $building->delete();
            }
            foreach ($destory->area as $area) {
                $filePath = $area->pic_path;
                if($filePath){
                    Storage::delete($filePath);
                }
                $area->delete();
            }
            $destory->delete();
        }
        return true;
    }

    function getDestoryFacotry($ids){
        return $this->factory->with('building', 'area')->whereIn('id', $ids)->get();
    }

    public function getSupData($company_id)
    {
        $factory = $this->factory->where('company_id', $company_id)->select('id', 'name','created_user','company_id')->get();
        $build = $this->bding->where('company_id', $company_id)->select('id', 'name', 'f_id')->get();
        $area = $this->area->where('company_id', $company_id)->select('id', 'name', 'b_id','f_id','floor')->get();

        return [
            $factory,
            $build,
            $area,
        ];
    }

    public function getReportAddress($f_id,$b_id,$a_id)
    {
        $factory = $this->factory->select('name','city','city_area','city_address','venderNo','phone')->find($f_id);
        $build = $this->bding->find($b_id)->name;
        $area = $this->area->find($a_id)->name;
        return (object) [
            'factory_name' => $factory->name,
            'city' => $factory->city,
            'city_area' => $factory->city_area,
            'city_address' => $factory->city_address,
            'build_name' => $build,
            'area_name' => $area,
            'venderNo'=>$factory->venderNo,
            'phone'=>$factory->phone,
        ];
    }
}
