<?php

namespace App\Http\Repositories;

use App\Models\Chemical_sds;
use Illuminate\Support\Facades\Storage;

class SdsBaseRepository
{
    function __construct(protected Chemical_sds $sdsbase){}

    function all(){
        return $this->sdsbase->all();
    }

    function store($sdsbase){
        return $this->sdsbase->create($sdsbase);
    }

    function find($id){
        return $this->sdsbase->find($id);
    }

    function update($id, $sdsbase){
        return $this->sdsbase->find($id)->update($sdsbase);
    }

    function destroy($id){
        
        $file =  $this->sdsbase->find($id);

        $filePath = $file->path;

        Storage::delete($filePath);

        return $file->delete();
    }
}