<?php

namespace App\Http\Repositories;

use App\Helpers\UserHelper;
use App\Models\Factory;
use App\Models\Factory_area;
use App\Models\Factory_bding;
use App\Models\Supply;
use Illuminate\Support\Facades\Auth;

class SupplierRepository
{
    function __construct(protected Supply $sup){}

    function supAll()
    {
        $id = Auth::user()->id;
        $company_id = UserHelper::getCompanyId();
        $data = $this->sup->where('c_id',$company_id)->orderby('id', 'asc')->get();
        return $data;
    }

    function findSup($id)
    {
        return $this->sup->find($id);
    }

    function getTax($company_id)
    {
        $data = $this->sup->where('c_id',$company_id)->select('id','tax','name','country','address','tel')->get();
        return $data;
    }


    function supUpdate($data,$id){
        $update = $this->sup->where('id',$id)->first();
        $update->update($data);

        return $update;
    }

    function getSupEdit($id){
        $data = $this->sup->where('id',$id)->first();

        return $data;
    }

    function supStore($data)
    {
        $sup = $this->sup->create($data);

        return $sup->id;
    }
    
    function supDestory(array $ids)
    {
        $datas = $this->sup->whereIn('id',$ids)->get();
        foreach($datas as $data){
            $data->delete();
        }
        return true;
    }

    function taxFind($tax){
        return $this->sup->where('c_id', UserHelper::getCompanyId())->where('tax',$tax)->first();
    }
}