<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserDecanChemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            '*.custodian'=>'required|integer',
            '*.factory_id'=>'required|integer',
            '*.build_id'=>'required|integer',
            '*.area_id'=>'required|integer',
            '*.factory_id'=>'required|integer',
            '*.serial_num'=>'required|string',
            '*.weight'=>'required|numeric|min:0.00000001|max:99999999.999',
        ];
    }

    public function messages(): array
    {
        return [
            '*.weight' => '最小數只能0.00000001。',
        ];
    }
}
