<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserNewChemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id'=>'nullable|integer',
            'chemical_name'=>'nullable|string',
            'chemical_other'=>'nullable|string',
            'unit'=>'required|string',
            'add_date'=> 'required|date',
            'ord_type'=>'required|string',
            'custodian'=>'required|integer',
            'ship_no'=>'nullable|string',
            'supplier_id'=>'nullable|integer',
            'cas_no'=>'required|string',
            'state'=>'required|string',
            'level'=>'required|string',
            'brand'=>'nullable|string',
            'bottleCount'=>'required|integer|min:1',
            'bottles' => 'nullable|array',
            'bottles.*.id' => 'nullable|integer',
            'bottles.*.serial_num' => 'nullable|string',
            'bottles.*.expired_date' => 'nullable|date_format:Y-m-d', 
            'weight'=>'required|numeric|min:0.00000001|max:99999999.999999999',
            'packag_unit'=>'required|string',
            'blends'=> 'nullable|array',
            'blends.*.id'=>'nullable|integer',
            'blends.*.chemical_id'=>'nullable|integer|required_with:blends.*.cas_no',
            'blends.*.cas_no'=>'nullable|string',
            'blends.*.conc'=>'nullable|string',
            'remark'=>'nullable|string',
            'use_factory'=>'required|integer',
            'use_build'=>'required|integer',
            'use_area'=>'required|integer',
            'use_avg'=>'required|string',
            'use_max'=>'required|string',
            'use_user'=>'required|string',
            'factory_id'=>'required|integer',
            'build_id'=>'required|integer',
            'area_id'=>'required|integer',
            'store_avg'=>'required|string',
            'store_max'=>'required|string'
        ];
    }
    protected function prepareForValidation()
    {
        $blends = $this->input('blends', []);
        $bottles = $this->input('bottles', []);
        foreach ($blends as $key => $blend) {
            $blends[$key]['cas_no'] = isset($blend['cas_no']) ? trim($blend['cas_no']) : null;
            $blends[$key]['conc'] = isset($blend['conc']) ? trim($blend['conc']) : null;
        }
        foreach ($bottles as $key => $bottle) {
            $bottles[$key]['serial_num'] = isset($bottle['serial_num']) ? trim($bottle['serial_num']) : null; // 去除 'serial_num' 的空格
            $bottles[$key]['expired_date'] = isset($bottle['expired_date']) ? trim($bottle['expired_date']) : null; // 去除 'expired_date' 的空格
        }
        $this->merge([
            'ship_no' => trim($this->ship_no),
            'cas_no' => trim($this->cas_no),
            'brand' => trim($this->brand),
            'weight' => trim($this->weight),
            'bottleCount' => trim($this->bottleCount),
            'blends' => $blends,
            'bottles' => $bottles,
            'remark' => trim($this->remark),
            

        ]);
    }
    public function messages(): array
    {
        return [
            'bottleCount.integer' => '瓶數只能是正整數。',
            'bottleCount.min' => '瓶數不能為0或負數。',
            'build_id'=>'請選擇棟別',
            'area_id'=>'請選擇儲存區',
            'chemical_id'=>'請輸入Cas NO.，並選擇化學品',
            'blends.*.chemical_id.required_with' => '請選擇混和物質下拉選單之化學品',
            'bottles.*.id.integer' => '系統錯誤：無效的瓶身ID。',
        ];
    }
}
