<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserSubChemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'sub_weight'=>'required|numeric|min:0.00000001|max:99999999.999',
            'operate_date'=> 'required|date',
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'weight' =>trim($this->sub_weight),
        ]);
    }
}
