<?php

namespace App\Http\Services;

use App\Http\Repositories\ChemicalBaseRepository;

class ChemicalBaseService
{
    function __construct(protected ChemicalBaseRepository $chemicalBaseRepository){}

    function all(){
        return $this->chemicalBaseRepository->all();
    }

    function store($chemical){

        return $this->chemicalBaseRepository->store($chemical);
    }
    
    function find($id){
        return $this->chemicalBaseRepository->find($id);
    }

    function findcas($casno){
        return $this->chemicalBaseRepository->findcas($casno);
    }

    function search($filters){
        return $this->chemicalBaseRepository->search($filters);
    }

    function destroy(array $ids){
        return $this->chemicalBaseRepository->destroy($ids);
    }
    
    function update($id,$data){
        return $this->chemicalBaseRepository->update($id,$data);
    }

    public function removeDateAndFirstUnderscore($inputString)
    {
        return preg_replace('/\d+_\d+-\d+-\d+(_)/', '', $inputString);
    }

    public function processMultipleFilenames(array $filenames)
    {
        return array_map([$this, 'removeDateAndFirstUnderscore'], $filenames);
    }

    function generateBitString( $request, $prefix, $count)
    {
        return implode('', array_map(function ($index) use ($request, $prefix) {
            return $request->input($prefix . '_' . $index) === 'true' ? 1 : 0;
        }, range(1, $count)));
    }

    function companyID()
    {
        return $this->chemicalBaseRepository->companyID();
    }

    public function UserCasNo(?string $searchTerm = null, ?array $specificCasNos = null): \Illuminate\Support\Collection
    {
        return $this->chemicalBaseRepository->UserCasNo($searchTerm, $specificCasNos);
    }
    
}