<?php

namespace App\Http\Services;

use App\Http\Repositories\ApprovalDocRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\FactoryChemicalRepository;
use App\Http\Repositories\FactoryRepositories;
use Exception;

class ChemicalDecantService
{

    function __construct(
        protected FactoryChemicalRepository $factory_chem,
        protected ChemicalOperationService $chem_operate,
        protected ChemicalOperationRepository $chem_operate_Rs,
        protected ChemicalOperationValidate $chem_operate_validate,
        protected ApprovalDocRepository $doc,
        protected FactoryRepositories $factory
    ) {}

    public function getDecantOperate($user, $company_id)
    {
        return $this->chem_operate_Rs->getDecant($user, $company_id);
    }

    //處理分裝化學品
    public function dacentChem($decantDatas, $id, $user)
    {
        $check = [];
        $factoryChem = $this->factory_chem->find($id);
        $checkDocs = $this->doc->chemConcFindDoc($factoryChem->chemical_id, $factoryChem->conc);
        $checkProperties = $factoryChem->chemical;
        // if ($checkDocs && ($checkProperties->toxic_moenv == 1 || $checkProperties->concerned == 1)) {
        //     $docArray = $checkDocs->toArray();
        //     foreach ($decantDatas as $decantData) {
        //         $hasMatch = collect($docArray)->contains(
        //             fn($checkDoc) =>
        //             $checkDoc['factory_id'] == $decantData['factory_id'] && $checkDoc['type_storage']
        //         );
        //         if (!$hasMatch) {
        //             $fact = $this->factory->findFactory($decantData['factory_id']);
        //             $check[] = $fact->name;
        //         }
        //     }
        // }
        // if (!empty($check)) {
        //     throw new Exception("此化學品在\n".implode("、\n", $check) . "\n無貯存核可");
        // }
        $totalWeight = array_sum(array_column($decantDatas, 'weight'));
        $this->validateWeight($totalWeight, $factoryChem->now_weight);


        foreach ($decantDatas as $decantData) {
            // 更新操作紀錄及分裝
            $this->recordDecantOperation($factoryChem, $decantData, $id);
            $this->updateChemicalWeight($factoryChem, $decantData['weight'], $user);
            $this->createNewDecant($decantData, $id, $user);
        }
    }

    //更新化學品
    protected function updateChemicalWeight($factoryChem, $decantWeight, $user)
    {
        $newWeight = $factoryChem->now_weight - $decantWeight;
        $factoryChem->now_weight = $newWeight;
        $factoryChem->updated_user = $user->id;
        $factoryChem->save();
    }
    //驗證重量
    protected function validateWeight($decantWeight, $currentWeight)
    {
        if ($decantWeight > $currentWeight) {
            throw new Exception("分裝重量超出目前存量");
        }
    }
    //分裝操作
    protected function recordDecantOperation($factoryChem, $decantData, $id)
    {
        //減少 資料用更新前的資料，備註 ，分裝到哪
        $operationData_D = array_merge(
            $factoryChem->toArray(),
            [
                'n_custodian' => $factoryChem['custodian'],
                'n_factory_id' => $decantData['factory_id'],
                'n_build_id' => $decantData['build_id'],
                'n_area_id' => $decantData['area_id'],
                'weight' => $decantData['weight'],
                'operate_date' => now(),
            ]
        );
        $this->chem_operate->operation($operationData_D, $id, $type = 'D');

        //增加 更新後的資料 備註，從哪裡來
        $operationData_E = array_merge(
            $factoryChem->toArray(),
            [
                'custodian' => $decantData['custodian'],
                'factory_id' => $decantData['factory_id'],
                'build_id' => $decantData['build_id'],
                'area_id' => $decantData['area_id'],
                'weight' => $decantData['weight'],
                'serial_num' => $decantData['serial_num'],
                'n_factory_id' => $factoryChem['factory_id'],
                'n_build_id' => $factoryChem['build_id'],
                'n_area_id' => $factoryChem['area_id'],
                'n_custodian' => $factoryChem['custodian'],
                'operate_date' => now(),
            ]
        );
        $this->chem_operate->operation($operationData_E, $id, $type = 'E');
    }

    //分裝紀錄
    protected function createNewDecant($decantData, $id, $user)
    {
        $newDecant = $this->factory_chem->copyData($id);
        $newDecant->serial_num = $decantData['serial_num'];
        $newDecant->parent_id = $id;
        $newDecant->ori_weight = $decantData['weight'];
        $newDecant->now_weight = $decantData['weight'];
        $newDecant->created_user = $user->id;
        $newDecant->updated_user = $user->id;
        $newDecant->custodian = $decantData['custodian'];
        $newDecant->factory_id = $decantData['factory_id'];
        $newDecant->build_id = $decantData['build_id'];
        $newDecant->area_id = $decantData['area_id'];
        $newDecant->created_at = now();
        $newDecant->updated_at = now();
        $newDecant->save();
    }
}
