<?php

namespace App\Http\Services;

use App\Helpers\UserHelper;
use App\Http\Repositories\ChemicalDisposalLog;
use App\Http\Repositories\ChemicalDisposalLogRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\FactoryChemicalRepository;

class ChemicalDisposalService{

    function __construct(protected FactoryChemicalRepository $factory_chem ,protected ChemicalOperationValidate $operate_validate,
                        protected ChemicalOperationService $chem_operate,protected ChemicalOperationRepository $chem_operate_res,
                        protected ChemicalDisposalLogRepository $chem_disposal_log)
    {
        
    }

    public function getDisposal($user){
        return $this->factory_chem->getDisposal($user);
    }

    public function getDisposalOperate($user)
    {
        $company_id = UserHelper::getCompanyId();
        return $this->chem_operate_res->getDisposal($user,$company_id);
    }
    //取得廢棄化學品異動紀錄
    public function getDisposalLog($user)
    {
        return $this->chem_disposal_log->getDisposalLog($user);
    }

    //廢棄化學品
    public function disposal($ids,$user)
    {
        foreach($ids as $id)
        {
            $factoryChem = $this->factory_chem->find($id);
            $factoryChem->updated_user = $user->id;
            $this->operate_validate->Operate_validate($factoryChem,$user);
            $this->disposalOperate($factoryChem,'H');
            $this->disposalLog($factoryChem,'H','新增廢棄');
            $factoryChem->now_weight = 0;
            $factoryChem->updated_at = now();
            $factoryChem->save();
        }
    }

    protected function disposalOperate($factoryChem,$type)
    {
        $operate = array_merge(
            $factoryChem->toArray(),
            [
                'weight'=>$factoryChem->now_weight,
                'operate_date' => now(),
            ]
            );
            $this->chem_operate->operation($operate,$factoryChem->id,$type);
    }
    protected function disposalLog($factoryChem,$type,$remark)
    {
        $log = array_merge(
            $factoryChem->toArray(),
            [
                'factory_chemical_id'=>$factoryChem->id,
                'type' => $type,
                'remark'=>$remark ?? '',
                'weight'=>$factoryChem->now_weight,
                'operate_date' => now(),
            ]
            );
            $this->chem_disposal_log->create($log);
    }

    public function restore($ids,$user)
    {
        foreach($ids as $id)
        {
            $operate = $this->chem_operate_res->find($id);
            $factoryChem = $this->factory_chem->find($operate->factory_chemical_id);
            $factoryChem->updated_user = $user->id;
            $factoryChem->now_weight = $operate->weight;
            $this->operate_validate->Operate_validate($factoryChem,$user);
            $this->disposalLog($factoryChem,'M','還原廢棄');
            $factoryChem->updated_at = now();
            $factoryChem->save();
            $operate->delete();
        }
    }
}