<?php

namespace App\Http\Services;

use App\Http\Repositories\AuthRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\FactoryRepositories;
use App\Http\Repositories\SupplierRepository;

class ChemicalOperationService
{

    function __construct(
        protected ChemicalOperationRepository $chem_op,
        protected FactoryRepositories $factory,
        protected AuthRepository $user,
        protected SupplierRepository $sup
    ) {}

    function operation($data, $fcId, $type)
    {
        $data['factory_chemical_id'] = $fcId;
        if ($type === 'D' || $type === 'E' || $type === 'F' || $type === 'G') {
            $factory_name = $this->factory->getFactory($data['n_factory_id'])->name;
            $build_name = $this->factory->getBuild($data['n_build_id'])->name;
            $area_name = $this->factory->getArea($data['n_area_id'])->name;
            $user_name = $this->user->idGet($data['n_custodian'])->contact_name;
        }
        if ($type === 'L' || $type === 'Q' || $type === 'P' || $type === 'N') {
            $sup_name = $this->sup->findSup($data['supplier_id'])->name;
        }
        $data['type'] = $type;
        switch ($type) {
            case 'A':
                $data['remark'] = '新增化學品';
                break;
            case 'B':
                $data['remark'] = '使用作業';
                break;
            case 'C':
                $data['remark'] = '製造';
                break;
            case 'D':
                $data['remark'] = '分裝(' . $user_name . ')到' . $factory_name . $build_name . $area_name;
                break;
            case 'E';
                $data['remark'] = '從' . $factory_name . $build_name . $area_name . '分裝(' . $user_name . ')';
                break;
            case 'F';
                $data['remark'] = '調撥至(' . $user_name . ')' . $factory_name . $build_name . $area_name;
                break;
            case 'G';
                $data['remark'] = '自' . $factory_name . $build_name . $area_name . '調入(' . $user_name . ')';
                break;
            case 'H';
                $data['remark'] = '註銷作業';
                break;
            case 'J';
                $data['remark'] = '盤點增加';
                break;
            case 'K';
                $data['remark'] = '轉入';
                break;
            case 'L';
                $data['remark'] = $data['remark'] ??'';
                break;
            case 'O';
                $data['remark'] = '輸入';
                break;
            case 'P';
                $data['remark'] = $data['remark'] ??'';
                break;
            case 'N';
                $data['remark'] = $data['remark'] ??'';
                break;
            case 'Q';
                $data['remark'] = '退回至' . $sup_name;
                break;
        }
        return $this->chem_op->operation($data);
    }

    function updatelog($data, $fcId, $company_id, $user_id)
    {
        $data['type'] = $data['ord_type'];
        $data['factory_chemical_id'] = $fcId;
        $data['created_user'] = $user_id;
        $data['company_id'] = $company_id;
        $data['remark'] = '資料更新' . $data['cas_no'];

        return $this->chem_op->operation($data);
    }

    function destory($data)
    {
        foreach ($data->factoryChem as $factory_chem) {
            $data->factory_chemical_id = $factory_chem->id;
            $this->chem_op->del($data);
        }
    }
}
