<?php

namespace App\Http\Services;

use Exception;

class ChemicalOperationValidate
{
    public function Operate_validate($data, $user)
    {
        if ($user->role === 'admin') {
            return; // 管理員無限制，直接返回
        }
        // 若是員工帳號，用戶的company_id必須與資料的belongs_parent一致，且用戶必須是該資料的 custodian
        if ($user->role === 'checker' || $user->role === 'auditor') {
            if ($data->company_id !== $user->belongs_parent || $data->custodian !== $user->id) {
                throw new Exception("無權限");
            }
            return;
        }
        if ($user->role === 'company' && $user->belongs_parent === $data->company_id) {
            if ($data->company_id !== $user->belongs_parent || $data->custodian !== $user->id) {
                throw new Exception("無權限");
            }
            return;
        }
        if ($user->role === 'company') {
            if ($data->company_id !== $user->id) {
                throw new Exception("無權限");
            }
            // 公司帳號可查看所有該公司下的資料，無需考慮 custodian_id
            return;
        }

        // 若帳號類型不符合，則回傳未授權
        throw new Exception("無權限");
    }
}
