<?php

namespace App\Http\Services;

use App\Http\Repositories\ApprovalDocRepository;
use App\Http\Repositories\AuthRepository;
use App\Http\Repositories\ChemicalBaseRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\FactoryRepositories;

class ChemicalReportService{
    function __construct(protected ChemicalOperationRepository $chem_operate,protected ChemicalBaseRepository $chem,protected AuthRepository $people,
                            protected FactoryRepositories $factory,protected ApprovalDocRepository $doc)
    {
        
    }

    public function getChemlist($user,$request)
    {
        return $this->chem_operate->getReportlist($user,$request);
    }

    public function getChemReport($request,$user)
    {
        //運作紀錄
        $chemReport = $this->chem_operate->manyReportGet($request,$user);
        //運作場所
        $onlyReport = $this->chem_operate->onlyReportGet($request,$user);
        $chemData = $this->chem->useReport($request->chemical_id);
        $op_people = $this->people->getOpUser($onlyReport->custodian);
        $companyData = $this->people->getOpUser($onlyReport->company_id);
        $factoryData = $this->factory->getReportAddress($onlyReport->factory_id,$onlyReport->build_id,$onlyReport->area_id);
        $docData = $this->doc->docOnlyFind($onlyReport->doc_id);
        $remainder = $this->chem_operate->remainder($request,$user);

        return [
            'chemOp'=>$chemReport,
            'chemData'=>$chemData,
            'op_people'=>$op_people,
            'companyData'=>$companyData,
            'docData'=>$docData,
            'remainder'=>$remainder,
            'factoryData'=>$factoryData
        ];
    }
}