<?php

namespace App\Http\Services;

use App\Helpers\UserHelper;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\ChemicalOrdRepository;
use App\Http\Repositories\ChemicalResidualLogRespository;
use App\Http\Repositories\FactoryChemicalRepository;

class ChemicalResidualService
{
    function __construct(
        protected FactoryChemicalRepository $factory_chem,
        protected ChemicalOperationValidate $operate_validate,
        protected ChemicalOperationService $chem_operate,
        protected ChemicalOperationRepository $chem_operate_res,
        protected ChemicalResidualLogRespository $resdiual_log,
        protected ChemicalOrdRepository $ord,
    ) {}

    function getResidual($user){
        $company_id = UserHelper::getCompanyId();
        return $this->chem_operate_res->getResidual($user,$company_id);
    }
    function getResidualLog($user){
        return $this->resdiual_log->getResidualLog($user);
    }
    function Residual($ids, $user)
    {
        foreach ($ids as $id) {
            $factoryChem = $this->factory_chem->find($id);
            $chem_ord = $this->ord->find($factoryChem->ord_id);
            $factoryChem->updated_user = $user->id;
            $this->operate_validate->Operate_validate($factoryChem, $user);
            $this->ResidualOperate($factoryChem, 'Q',$chem_ord);
            $this->ResidualLog($factoryChem,'Q','殘氣退回');
            $factoryChem->now_weight = 0;
            $factoryChem->updated_at = now();
            $factoryChem->save();
        }
    }
    protected function ResidualOperate($factoryChem,$type,$chem_ord)
    {
        $operate = array_merge(
            $factoryChem->toArray(),
            [
                'supplier_id'=>$chem_ord->supplier_id,
                'weight'=>$factoryChem->now_weight,
                'operate_date' => now(),
            ]
            );
            $this->chem_operate->operation($operate,$factoryChem->id,$type);
    }
    protected function ResidualLog($factoryChem,$type,$remark)
    {
        $log = array_merge(
            $factoryChem->toArray(),
            [
                'factory_chemical_id'=>$factoryChem->id,
                'type' => $type,
                'remark'=>$remark ?? '',
                'weight'=>$factoryChem->now_weight,
                'operate_date' => now(),
            ]
            );
            $this->resdiual_log->create($log);
    }
    public function restore($ids,$user)
    {
        foreach($ids as $id)
        {
            $operate = $this->chem_operate_res->find($id);
            $factoryChem = $this->factory_chem->find($operate->factory_chemical_id);
            $factoryChem->updated_user = $user->id;
            $factoryChem->now_weight = $operate->weight;
            $this->operate_validate->Operate_validate($factoryChem,$user);
            $this->ResidualLog($factoryChem,'S','殘氣還原');
            $factoryChem->updated_at = now();
            $factoryChem->save();
            $operate->delete();
        }
    }
}
