<?php

namespace App\Http\Services;


use App\Http\Repositories\ChemicalReviewRepository;

class ChemicalReviewService
{
    function __construct(protected ChemicalReviewRepository $chemicalReview){}

    function all(){
        return $this->chemicalReview->all();
    }

    function store($chemical){

        return $this->chemicalReview->store($chemical);
    }

    function findcase($casno)
    {
        return $this->chemicalReview->findcase($casno);
    }
    
    function find($id){
        return $this->chemicalReview->find($id);
    }

    function search(){
        return $this->chemicalReview->search();
    }

    function destroy(array $ids){
        return $this->chemicalReview->destroy($ids);
    }
    
    function update($id,$data){
        return $this->chemicalReview->update($id,$data);
    }

    public function removeDateAndFirstUnderscore($inputString)
    {
        return preg_replace('/\d+_\d+-\d+-\d+(_)/', '', $inputString);
    }

    public function processMultipleFilenames(array $filenames)
    {
        return array_map([$this, 'removeDateAndFirstUnderscore'], $filenames);
    }

    function generateBitString($request, $prefix, $count)
    {
        return implode('', array_map(function ($index) use ($request, $prefix) {
            return $request->input($prefix . '_' . $index) === 'true' ? 1 : 0;
        }, range(1, $count)));
    }
    
    function companyID()
    {
        return $this->chemicalReview->companyID();
    }
}