<?php

namespace App\Http\Services;

use App\Helpers\UserHelper;
use App\Http\Repositories\ApprovalDocRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\ChemicalSellLogRepository;
use App\Http\Repositories\FactoryChemicalRepository;
use Exception;
use Illuminate\Support\Facades\DB;

class ChemicalSellService
{

    function __construct(
        protected FactoryChemicalRepository $factory_chem,
        protected ChemicalOperationService $chem_operate,
        protected ChemicalSellLogRepository $chem_Sell,
        protected ChemicalOperationRepository $chem_operate_res,
        protected ChemicalOperationValidate $operate_validate,
        protected ApprovalDocRepository $doc
    ) {}


    public function getSell($user)
    {
        return $this->chem_Sell->getSellLog($user);
    }

    //取得運作紀錄
    public function getSellOperate($user)
    {
        $company_id = UserHelper::getCompanyId();
        return $this->chem_operate_res->getSell($user, $company_id);
    }
    public function sell($ids, $sup, $user, $remark)
    {

        $factoryChems = $this->factory_chem->manyFindFactoryChem($ids);
        if ($factoryChems->isEmpty()) {
            throw new Exception("找不到任何化學品");
        }
        $errorItems = [];
        $operate_date = now()->toDateString();
        // foreach ($factoryChems as $id => $factoryChem) {
        //     $checkDocs = $this->doc->chemFactoryFindDoc($factoryChem->chemical_id, $factoryChem->conc, $factoryChem->factory_id,$operate_date); //化學品位置與核可證運作編號相符的文件
        //     $checkProperties = $factoryChem->chemical; //用於化學品特性
        //     if ($checkDocs && ($checkProperties->toxic_moenv == 1 || $checkProperties->concerned == 1)) {
        //         if (!$checkDocs['type_sell']) {
        //             $errorItems[] = $factoryChem->serial_num . " (" . $factoryChem->cas_no . ") ";
        //         }
        //     }else if(!$checkDocs && ($checkProperties->toxic_moenv == 1 || $checkProperties->concerned == 1))
        //     {
        //         $errorItems[] = $factoryChem->serial_num . " (" . $factoryChem->cas_no . ") ";
        //     }
        // }
        // // 若有錯誤，則回傳錯誤訊息，不執行存入
        // if (!empty($errorItems)) {
        //     throw new Exception(implode(", ", $errorItems)."無販賣核可");
        // }
        DB::beginTransaction();
        try {
            foreach ($factoryChems as $id => $factoryChem) {
                $this->scordOperate($factoryChem, $sup, $user, 'N', $remark);
                $this->SellLog($factoryChem, 'N', $remark, $user, $sup);
                $factoryChem->now_weight = 0;
                $factoryChem->save();
            }
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    protected function scordOperate($factoryChem, $sup, $user, $type, $remark)
    {
        $operate = array_merge(
            $factoryChem->toArray(),
            [
                'remark' => $remark,
                'weight' => $factoryChem->now_weight,
                'operate_date' => now(),
                'supplier_id' => $sup,
                'created_user' => $user->id,
                'updated_user' => $user->id,
            ]
        );
        $this->chem_operate->operation($operate, $factoryChem->id, $type);
    }

    protected function SellLog($factoryChem, $type, $remark, $user, $sup)
    {
        $log = array_merge(
            $factoryChem->toArray(),
            [
                'factory_chemical_id' => $factoryChem->id,
                'type' => $type,
                'remark' => $remark ?? '',
                'supplier_id' => $sup,
                'weight' => $factoryChem->now_weight,
                'operate_date' => now(),
                'created_user' => $user->id,
                'updated_user' => $user->id,
            ]
        );
        $this->chem_Sell->create($log);
    }

    public function restore($ids, $user)
    {
        foreach ($ids as $id) {
            $operate = $this->chem_operate_res->find($id);
            $factoryChem = $this->factory_chem->find($operate->factory_chemical_id);
            $factoryChem->updated_user = $user->id;
            $factoryChem->now_weight = $operate->weight;
            $this->operate_validate->Operate_validate($factoryChem, $user);
            $this->SellLog($factoryChem, 'M', '賣出復原', $user, $operate->supplier_id);
            $factoryChem->updated_at = now();
            $factoryChem->save();
            $operate->delete();
        }
    }
}
