<?php

namespace App\Http\Services;

use App\Http\Repositories\ApprovalDocRepository;
use App\Http\Repositories\AuthRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\ChemicalOrdRepository;
use App\Http\Repositories\ChemicalSubLogRepository;
use App\Http\Repositories\FactoryChemicalRepository;
use App\Http\Repositories\FactoryRepositories;
use App\Models\User;
use Exception;

class ChemicalSubService
{
    function __construct(
        protected AuthRepository $users,
        protected FactoryRepositories $factory,
        protected FactoryChemicalRepository $factory_chem,
        protected ChemicalOperationService $chem_op,
        protected ChemicalOrdRepository $ord,
        protected ChemicalOperationRepository $Chem_op_res,
        protected ChemicalSubLogRepository $chem_sub_change,
        protected ChemicalOperationValidate $chem_validate,
        protected ApprovalDocRepository $doc
    ) {}

    //取得Sub頁面搜尋欄位資料
    function getSearchSelect($company_id, $user)
    {
        $factory = $this->factory->getSupData($company_id);

        $users = $this->users->getSupUser($company_id, $user->id);

        return ['factory' => $factory[0], 'build' => $factory[1], 'area' => $factory[2], 'custodian' => $users];
    }
    //取得Sub頁面化學品資料
    function getFactoryChem($request, $user, $company_id)
    {
        return $this->factory_chem->getSearchChem($request, $user, $company_id);
    }

    //取得使用運作紀錄
    function getSubOperation($user, $company_id)
    {
        return $this->Chem_op_res->getSub($user, $company_id);
    }

    //取得異動紀錄
    function getSubChange($user, $company_id)
    {
        $subChange = $this->chem_sub_change->getSubChange($user, $company_id);
        return $subChange;
    }

    //使用操作
    function subChem($request, $factoryChem_id, $user, $company_id)
    {
        $today = now()->toDateString();
        
        $obj_factoryChem = $this->factory_chem->find($factoryChem_id);
        // $checkDocs = $this->doc->chemFactoryFindDoc($obj_factoryChem->chemical_id, $obj_factoryChem->conc, $obj_factoryChem->factory_id,$request['operate_date']);
        // $checkProperties = $obj_factoryChem->chemical; //用於化學品特性
        // $shouldCheck = $checkProperties->toxic_moenv == 1 || $checkProperties->concerned == 1;
        // if ($shouldCheck) {
        //     // 如果有核可文件，但裡面沒有 type_use
        //     if ($checkDocs && !$checkDocs['type_use']) {
        //         throw new Exception("{$obj_factoryChem->serial_num} ({$obj_factoryChem->cas_no}) 無使用核可", 422);
        //     }
        
        //     // 如果根本沒核可文件
        //     if (!$checkDocs) {
        //         throw new Exception("{$obj_factoryChem->serial_num} ({$obj_factoryChem->cas_no}) 無使用核可", 422);
        //     }
        // }
        $chemicalOrd = $this->ord->find($obj_factoryChem->ord_id);
        if($request['operate_date'] < $chemicalOrd->add_date)
        {
            throw new Exception('使用時間不能比購買日期早', 422);
        }
        if($request['operate_date'] > $today){
            throw new Exception('使用時間不能比當日晚', 422);
        }
        $factoryChem = $obj_factoryChem->toArray();

        $new_weight = $this->calculateNewWeight($factoryChem, $request['sub_weight']);
        $this->chem_validate->Operate_validate($obj_factoryChem, $user);
        $this->checkWeightValidity($new_weight);
        $this->updateFactoryChemWeight($new_weight, $factoryChem_id, $user);

        $operationData = $this->prepareOperationData($factoryChem, $request);
        $operate = $this->recordSubtractionOperation($operationData, $factoryChem_id, $user);
        $this->recordSubChange($operationData,$operate->toArray(),$user);
    }
    //計算使用
    protected function calculateNewWeight($factoryChem, $sub_weight)
    {
        return  $factoryChem['now_weight'] - $sub_weight;
    }
    //驗證重量庫存
    protected function checkWeightValidity($new_weight)
    {
        if ($new_weight < 0) {
            throw new Exception('使用超過現有庫存', 422);
        }
    }
    //更新化學品剩餘量
    protected function updateFactoryChemWeight($new_weight, $factoryChem_id, $user)
    {
        $data = [
            'now_weight' => $new_weight,
            'updated_user' => $user->id,
        ];
        $this->factory_chem->update($data, $factoryChem_id);
    }
    //合併運作紀錄資料
    protected function prepareOperationData($factoryChem, $request)
    {
        return array_merge(
            $factoryChem,
            [
                'weight' => $request['sub_weight'],
                'operate_date' => $request['operate_date'],
            ]
        );
    }
    //使用運作紀錄
    protected function recordSubtractionOperation($operationData, $factoryChem_id, $user)
    {
        return $this->chem_op->operation($operationData, $factoryChem_id, $type = 'B');
    }

    //使用異動紀錄新增
    protected function recordSubChange($factoryChem, $operationData,$user)
    {
        $factoryChem['factory_chemical_id'] = $factoryChem['id'];
        $factoryChem['chemical_operate_id'] = $operationData['id'];
        $factoryChem['remark'] = '新增使用';
        $factoryChem['ori_weight'] = $operationData['weight'];
        $factoryChem['new_weight'] = $operationData['weight'];
        $factoryChem['created_user'] = $user->id;
        $factoryChem['updated_user'] = $user->id;
        $this->chem_sub_change->create($factoryChem);
    }

    //修改使用運作
    function subOperateUpdate($request, $operate_id, $user, $company_id)
    {
        $today = now()->toDateString();
        $operate = $this->Chem_op_res->find($operate_id);
        $factoryChem = $this->factory_chem->find($operate->factory_chemical_id);
        $chemicalOrd = $this->ord->find($factoryChem->ord_id);
        if($request['operate_date'] < $chemicalOrd->add_date)
        {
            throw new Exception('使用時間不能比購買日期早', 422);
        }
        if($request['operate_date'] > $today){
            throw new Exception('使用時間不能比當日晚', 422);
        }
        $checkDisposal = $this->Chem_op_res->checkDisposal($operate);
        if($checkDisposal && $checkDisposal->type ==='H'){
            throw new Exception('化學品已廢棄', 422);
        }
        $this->chem_validate->Operate_validate($operate, $user);

        $this->handleSubOperateUpdate($operate, $request, $user);
    }

    //修改使用運作邏輯
    protected function handleSubOperateUpdate($operate, $request, $user)
    {
        $oriSub_weight = $operate->weight;
        $newSub_weight = $request['sub_weight'];
        $nowSub_weight = $oriSub_weight - $newSub_weight;

        $factoryChem = $this->factory_chem->find($operate->factory_chemical_id);
        $new_weight = $this->updateChemWeightAndCheck($factoryChem, $nowSub_weight, $user);

        $this->updateOperateRecord($request, $operate->id, $newSub_weight);
        $this->recordChangeForUpdate($operate, $newSub_weight, $user, $request,'修改使用');
    }
    //更新運作紀錄
    protected function updateOperateRecord($request, $operate_id, $newSub_weight)
    {
        $request['weight'] = $newSub_weight;
        unset($request['sub_weight']);
        $this->Chem_op_res->update($request, $operate_id);
    }

    // 記錄異動更新
    protected function recordChangeForUpdate($operate, $newSub_weight, $user, $request,$remark)
    {
        $changeData = [
            'chemical_operate_id' => $operate->id,
            'factory_chemical_id' => $operate->factory_chemical_id,
            'serial_num' => $operate->serial_num,
            'chemical_id' => $operate->chemical_id,
            'cas_no' => $operate->cas_no,
            'custodian' => $operate->custodian,
            'ori_weight' => $operate->weight,
            'new_weight' => $newSub_weight,
            'factory_id' => $operate->factory_id,
            'build_id' => $operate->build_id,
            'area_id' => $operate->area_id,
            'company_id' => $operate->company_id,
            'created_user' => $operate->created_user,
            'updated_user' => $user->id,
            'operate_date' => $request['operate_date'],
            'remark' => $remark
        ];
        $this->chem_sub_change->create($changeData);
    }

    // 更新化學品重量並檢查有效性
    protected function updateChemWeightAndCheck($factoryChem, $nowSub_weight, $user)
    {
        $new_weight = $factoryChem->now_weight + $nowSub_weight;
        $this->checkWeightValidity($new_weight);
        $this->updateFactoryChemWeight($new_weight, $factoryChem->id, $user);
        return $new_weight;
    }

    //刪除運作紀錄
    function delOperate($id, $user, $company_id)
    {
        $operate = $this->Chem_op_res->find($id);
        $checkDisposal = $this->Chem_op_res->checkDisposal($operate);
        if($checkDisposal && $checkDisposal->type ==='H'){
            throw new Exception('化學品已廢棄', 422);
        }
        $this->chem_validate->Operate_validate($operate, $user);
        $this->restoreChemWeight($operate);
        $this->deleteOperationRecord($operate, $user);
    }
    // 恢復工廠化學品重量
    protected function restoreChemWeight($operate)
    {
        $factoryChem = $this->factory_chem->find($operate->factory_chemical_id);
        $factoryChem->now_weight += $operate->weight;
        $factoryChem->update();
    }

    // 刪除運作紀錄並記錄異動
    protected function deleteOperationRecord($operate, $user)
    {
        $operate->chemical_operate_id = $operate->id;
        $operate->remark = '刪除使用';
        $operate->ori_weight = $operate->weight;
        $operate->new_weight = 0;
        $operate->created_user = $user->id;
        $operate->updated_user = $user->id;
        $this->chem_sub_change->create($operate->toArray());
        $this->Chem_op_res->delSubOperate($operate->id);
    }
}
