<?php

namespace App\Http\Services;

use App\Helpers\UserHelper;
use App\Http\Repositories\ApprovalDocRepository;
use App\Http\Repositories\ChemicalBaseRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\FactoryChemicalRepository;
use App\Http\Repositories\FactoryRepositories;
use App\Models\ApprovalDocList;
use Exception;

use function PHPUnit\Framework\isEmpty;

class ChemicalTransferService
{

    function __construct(
        protected FactoryChemicalRepository $factory_chem,
        protected ChemicalOperationService $chem_operate,
        protected ChemicalOperationRepository $chem_operate_res,
        protected ApprovalDocRepository $doc,
        protected ChemicalBaseRepository $chem,
        protected FactoryRepositories $factory,
    ) {}

    public function getTransferOperate($user)
    {
        $id = $user->id;
        $company_id = UserHelper::getCompanyId();
        return $this->chem_operate_res->getTransfer($user, $company_id);
    }

    public function chemTransferOperate($data, $user)
    {
        $this->updateFactoryChenm($data);
        $this->recordTransferOperate($data, $user);
    }
    //更新化學品地點與保管人
    protected function updateFactoryChenm($data)
    {
        $same = [];
        $check = [];
        $ids = $data->id;
        foreach ($ids as $id) {
            $hasMatch = false;
            $ori = $this->factory_chem->find($id);
            $checkDocs = $this->doc->chemConcFindDoc($ori->chemical_id,$ori->conc);
            $checkProperties = $this->chem->find($ori->chemical_id);
            if (
                $ori->custodian === $data->custodian && $ori->factory_id === $data->factory_id &&
                $ori->build_id === $data->build_id && $ori->area_id === $data->area_id
            ) {
                $same[] = $ori->cas_no;
            }
            // if($checkDocs && ($checkProperties->toxic_moenv ==1 || $checkProperties->concerned ==1)){
            //     foreach($checkDocs->toArray() as $checkDoc)
            //     {
            //         if($checkDoc['factory_id'] == $data->factory_id && $checkDoc['type_storage'])
            //         {
            //             $hasMatch = true;
            //             break; // 有符合的直接跳出迴圈
                        
            //         }
            //     }
            //     if(!$hasMatch)
            //     {
            //         $check[] = $ori->serial_num . "(". $ori->cas_no . ")";
            //     }
                
            // }
        }
        if(!empty($same)){
            throw new Exception(implode("、",$same)."同保管人同地點");
        }
        // if(!empty($check))
        // {
        //     $fact = $this->factory->findFactory($data->factory_id);
        //     throw new Exception("以下化學品在".$fact->name."無貯存核可\n". implode("、\n",$check));
        // }
        
        $updateData = [
            'custodian' => $data->custodian,
            'factory_id' => $data->factory_id,
            'build_id' => $data->build_id,
            'area_id' => $data->area_id,
        ];

        return $this->factory_chem->manyFind($updateData, $ids);
    }
    //新增調撥運作紀錄
    protected function recordTransferOperate($data, $user)
    {

        foreach ($data->id as $id) {
            $factoryChem = $this->factory_chem->find($id);
            //減少，更新前資料，備註，調撥後的地方
            $operate = array_merge(
                $factoryChem->toArray(),
                [
                    'n_factory_id' => $data->factory_id,
                    'n_build_id' => $data->build_id,
                    'n_area_id' => $data->area_id,
                    'n_custodian' => $factoryChem->custodian,
                    'factory_id' => $factoryChem->factory_id,
                    'build_id' => $factoryChem->build_id,
                    'area_id' => $factoryChem->area_id,
                    'created_user' => $user->id,
                    'updated_user' => $user->id,
                    'weight' => $factoryChem->now_weight,
                    'operate_date' => now(),
                ]
            );
            $this->chem_operate->operation($operate, $id, $type = 'F');
            //增加，更新後資料，備註，從哪裡調過來
            $operate = array_merge(
                $factoryChem->toArray(),
                [
                    'n_factory_id' => $factoryChem->factory_id,
                    'n_build_id' => $factoryChem->build_id,
                    'n_area_id' => $factoryChem->area_id,
                    'n_custodian' => $data->custodian,
                    'factory_id' => $data->factory_id,
                    'build_id' => $data->build_id,
                    'area_id' => $data->area_id,
                    'custodian' => $data->custodian,
                    'created_user' => $user->id,
                    'updated_user' => $user->id,
                    'weight' => $factoryChem->now_weight,
                    'operate_date' => now(),
                ]
            );
            $this->chem_operate->operation($operate, $id, $type = 'G');
        }
    }
}
