<?php

namespace App\Http\Services;

use App\Http\Repositories\ChemicalOperationRepository;
use Illuminate\Support\Facades\Auth;

class DashboardService{

    public function __construct(protected ChemicalOperationRepository $chem_op) {
        
    }

    function moenvCount(){
        $user = Auth::user();
        $month = date('n');
        $helfYear = ($month >= 1 && $month <= 6) ? '01-01' : '07-01';
        $requestR = (object)['type'=> 'r','helfYear'=>$helfYear];
        $requestF = (object)['type'=> 'f'];
        $requestD = (object)['type'=> 'd'];
        $toxicCount = $this->chem_op->moenvCount($toxic = 1,$concerned = 0);
        $concernedCount = $this->chem_op->moenvCount($toxic = 0,$concerned = 1);
        $priorityCount = $this->chem_op->otherCount($priority = 1,$hazards = 0,$pioneer = 0);
        $dangerRegularCount = $this->chem_op->getDeclarableFactoryCounts($user,$requestR)->first();
        $dangerFirstCount = $this->chem_op->getDeclarableFactoryCounts($user,$requestF)->first();
        $dangerDynamicCount = $this->chem_op->getDeclarableFactoryCounts($user,$requestD)->first();
        $pioneerCount = $this->chem_op->otherCount($priority = 0,$hazards = 0,$pioneer = 1);

        return response()->json(
        ['toxic' =>$toxicCount,
            'concerned'=> $concernedCount,
            'priority'=>$priorityCount,
            'dangerRegularCount'=>$dangerRegularCount->declaration_count ?? 0,
            'dangerFirstCount'=>$dangerFirstCount->declaration_count ?? 0,
            'dangerDynamicCount'=>$dangerDynamicCount->declaration_count ?? 0,
            'pioneer'=>$pioneerCount]
        );
    }
}