<?php
namespace App\Http\Services;

use App\Http\Repositories\FactoryChemicalRepository;
use App\Http\Repositories\FactoryRepositories;
use Exception;
use Illuminate\Support\Facades\Auth;

class FactoryServices{

    function __construct(protected FactoryRepositories $factory,protected FactoryChemicalRepository $factory_chem){}

    public function getFactory($id)
    {
        return $this->factory->getFactory($id);
    }
    function findFactory($id)
    {
        return $this->factory->findFactory($id);
    }

    public function getFactoryAll()
    {
        $data = $this->factory->getFactoryAll();
        $factory = [];

        foreach($data as $factoryData){
        $address = $factoryData['city'] . $factoryData['city_area'] . $factoryData['city_address'];
        $total_bding = $factoryData->building->count();
        $total_area = $factoryData->area->count();
        $factory[] = [
            'id' => $factoryData['id'],
            'name' =>$factoryData['name'],
            'address' =>$address,
            't_bding' =>$total_bding,
            't_area' =>$total_area,
        ];
    }
        return $factory;
    }

    public function factoryStore($data)
    {
        $user = Auth::user();
        if($this->factory->checkFactoryName($data['name'],$user)){
            throw new Exception("名稱重複");
        }
        return $this->factory->factoryStore($data);
    }
    public function factoryUpdate($data,$id)
    {
        $user = Auth::user();
        if($this->factory->checkUpdateFactoryName($data['name'],$id,$user)){
            throw new Exception("名稱重複");
        }
        return $this->factory->factoryUpdate($data,$id);
    }

    public function checkBdingName($name,$f_id){
        return $this->factory->checkBdingName($name,$f_id);
    }
    public function bdingStore($data)
    {
        if ($this->factory->checkBdingName($data['name'],$data['f_id'])) {
            throw new Exception("名稱重複");
        }
        return $this->factory->bdingStore($data);
    }
    public function bdingUpdate($data,$id)
    {
        if ($this->factory->checkUpdateBdingName($data['name'],$data['f_id'],$id)) {
            throw new Exception("名稱重複");
        }
        return $this->factory->bdingUpdate($data,$id);
    }
    public function bdingDstory($id)
    {
        $areas = $this->factory->getBuild($id);
        foreach($areas->area as $area){
            $haveArea = $this->factory_chem->haveArea($area->id);
            if($haveArea){
                throw new Exception("此棟還有化學品");
            }
        }
        $areas->area()->delete();
        return $this->factory->bdingDstory($id);
    }

    public function checkAreaName($name,$f_id,$b_id)
    {
        return $this->factory->checkAreaName($name,$f_id,$b_id);
    }
    public function areaStore($data)
    {
        if ($this->factory->checkAreaName($data['name'],$data['f_id'],$data['b_id'])) {
            throw new Exception("名稱重複");
        }
        return $this->factory->areaStore($data);
    }

    public function areaUpdate($data,$id)
    {
        if($this->factory->checkUpdateAreaName($data['name'],$data['b_id'],$id)){
            throw new Exception("名稱重複");
        }
        return $this->factory->areaUpdate($data,$id);
    }

    public function areaData($id)
    {
        return $this->factory->areaData($id);
    }

    public function fileUpdate($data,$id)
    {
        return $this->factory->fileUpdate($data,$id);
    }
    public function areaDestory($id)
    {
        if($this->factory_chem->haveArea($id)){
            throw new Exception("此儲存區還存在化學品");
        }
        return $this->factory->areaDestory($id);
    }
    public function picDestory($id)
    {
        return $this->factory->picDestory($id);
    }

    public function listDestory(array $ids)
    {
        $errorData = [];
        $factories = $this->factory->getDestoryFacotry($ids);
        foreach($factories as $factory){
            foreach($factory->area as $area){
                if($this->factory_chem->haveArea($area->id)){
                    $errorData[$factory->name][] = $area->name; 
                }
            }
        }
        if (!empty($errorData)) {
            $errorMessages = [];
            foreach ($errorData as $factoryName => $areas) {
                $errorMessages[] = "{$factoryName}";
            }
            throw new Exception(implode("、", $errorMessages). " 還存在化學品");
        }
        return $this->factory->listDestory($ids);
    }
}

?>