<?php

namespace App\Http\Services;

use App\Helpers\UserHelper;
use App\Http\Repositories\ApprovalDocRepository;
use App\Http\Repositories\AuthRepository;
use App\Http\Repositories\ChemicalBaseRepository;
use App\Http\Repositories\ChemicalMixRepository;
use App\Http\Repositories\ChemicalOperationRepository;
use App\Http\Repositories\ChemicalOrdlLogRepository;
use App\Http\Repositories\ChemicalOrdRepository;
use App\Http\Repositories\FactoryChemicalRepository;
use App\Http\Repositories\FactoryRepositories;
use App\Http\Repositories\SupplierRepository;
use App\Imports\ChemicalOrdImport;
use App\Models\ApprovalDocList;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Ramsey\Uuid\Type\Integer;

class UserNewChemService
{
    function __construct(
        protected FactoryChemicalRepository $factory_chem,
        protected ChemicalMixRepository $chem_mix,
        protected SupplierRepository $sup,
        protected FactoryRepositories $factory,
        protected AuthRepository $user,
        protected ChemicalOperationService $chem_op,
        protected ChemicalOperationRepository $chem_op_Res,
        protected ChemicalOrdRepository $ord,
        protected ChemicalOrdChangeService $chem_change,
        protected ChemicalOrdlLogRepository $chem_cahnge_res,
        protected ChemicalOperationValidate $chem_operate_validate,
        protected ChemicalBaseRepository $Chemical,
        protected SupplierRepository $supply,
        protected ApprovalDocRepository $doc_list,
    ) {}

    function getInfo($company_id, $id)
    {
        $data = $this->sup->getTax($company_id);
        $factory = $this->factory->getSupData($company_id);
        $user = $this->user->getSupUser($company_id, $id);
        $doc = $this->doc_list->docNow();
        return ['factory' => $factory[0], 'build' => $factory[1], 'area' => $factory[2], 'data' => $data, 'user' => $user, 'doc' => $doc];
    }
    function getOrd($company_id, $user)
    {
        return $this->ord->getOrd($company_id, $user);
    }

    function getEditOrd($id)
    {
        $user = auth()->user();
        $findOrd = $this->ord->find($id);
        $this->chem_operate_validate->Operate_validate($findOrd, $user);
        return $findOrd;
    }

    function getFactoryChem($company_id, $user)
    {
        return $this->factory_chem->getFactoryChem($company_id, $user);
    }

    function get3DFactoryChemArea($area_id)
    {
        $factory_Data = $this->factory_chem->get3DFactoryChemArea($area_id);
        $factory = $this->factory->getAreaInfo($area_id);
        $factory->pic_path = config('app.asset_url') . Storage::url($factory->pic_path);
        if (!$factory_Data->isEmpty()) {
            return ['factory_Data' => $factory_Data, 'factory' => $factory];
        } else {
            return ['factory' => $factory];
        }
    }

    function get3DFactoryChemBuild($build_id)
    {
        $factory_Data = $this->factory_chem->get3DFactoryChemBuild($build_id);
        $factory = $this->factory->getBuildInfo($build_id);
        if (!$factory_Data->isEmpty()) {
            return ['factory_Data' => $factory_Data, 'factory' => $factory];
        } else {
            return ['factory' => $factory];
        }
    }

    function get3DFactoryChemFloor($build_id, $floor)
    {
        $factory_Data = $this->factory_chem->get3DFactoryChemFloor($build_id, $floor);
        $factory = $this->factory->getFloorInfo($build_id, $floor);
        if (!$factory_Data->isEmpty()) {
            return ['factory_Data' => $factory_Data, 'factory' => $factory];
        } else {
            return ['factory' => $factory];
        }
    }

    function getChemChange($company_id, $user)
    {
        return $this->chem_cahnge_res->getChemChange($company_id, $user);
    }
    function chemAddStore($data, $user_id, $company_id)
    {

        if ($data['bottleCount'] <= 0) {
            throw new Exception('瓶數量不得小於0');
        }
        //修改訂單
        if (isset($data['id'])) {
            DB::beginTransaction();
            try {
                $data['ord_id'] = $data['id'];
                $orddata = $this->ord->find($data['ord_id']);
                // if (!empty($orddata->doc_list) && !empty($orddata->doc_list->doc_id)) {
                //     $chem_doc = $this->doc_list->docOnlyFind($orddata->doc_list->doc_id);

                //     if ($chem_doc) {
                //         if (
                //             $chem_doc->start_date > $data['add_date'] ||
                //             $chem_doc->end_date < $data['add_date']
                //         ) {
                //             throw new Exception('超出核可文件時間範圍');
                //         }
                //     }
                // }

                $factoryChems = $this->factory_chem->getBottlesByOrderId($data['ord_id']);
                foreach ($factoryChems as $factoryChem) {
                    if ($factoryChem['ori_weight'] !== $factoryChem['now_weight']) {
                        throw new Exception("化學品已使用過");
                    }
                }
                $ori_type = $orddata->ord_type;
                $data['company_id'] = $orddata->company_id;
                $data['created_user'] = $orddata->created_user;
                $data['updated_user'] = $user_id;
                $this->ord->update($data);
                $this->chem_change->update($data); //異動紀錄

                // 檢查 blends 第一筆的 cas_no 與 conc 是否有填寫
                if (
                    isset($data['blends'][0]) &&
                    (empty($data['blends'][0]['cas_no']) || empty($data['blends'][0]['conc']))
                ) {
                    throw new Exception("請填寫混合物 CAS No 與濃度");
                }
                // 處理混合物
                if (!empty($data['blends']) && is_array($data['blends'])) {
                    if (isset($data['blends'][0]['id']) || isset($data['blends'][0]['cas_no'])) {
                        $this->chem_mix->update($data['blends'], $data['ord_id']);
                    }
                }

                $data['ori_weight'] = $data['weight'];
                $data['now_weight'] = $data['weight'];
                $data['conc'] = 0;
                $data['bottle_type']=0;
                $data['chemical_id']=0;
                $newSerials = [];
                $serialNumSet = [];
                foreach ($data['bottles'] as $bottle) {
                    if (!isset($bottle['serial_num'])) {
                        throw new Exception("請填寫瓶編號");
                    }
                    if (in_array($bottle['serial_num'], $serialNumSet)) {
                        throw new Exception("瓶編號重複：" . $bottle['serial_num']);
                    }
                    $serialNumSet[] = $bottle['serial_num'];
                    $data['serial_num'] = $bottle['serial_num'];
                    $data['expired_date'] = $bottle['expired_date'] ?? null;
                    if (isset($bottle['id'])) {
                        $fcId = $bottle['id'];
                        $updateData = [
                            'serial_num' => $data['serial_num'],
                            'expired_date' => $data['expired_date'],
                            'now_weight' => $data['weight'],
                            'ori_weight' => $data['ori_weight'],
                            'custodian' =>$data['custodian'],
                            'level' =>$data['level'],
                            'updated_user' =>$user_id,
                            'chemical_name'=>$data['chemical_name'],
                            'chemical_other'=>$data['chemical_other']

                        ];
                        $this->factory_chem->update($updateData, $fcId);
                        $this->chem_op_Res->updateAdd($data, $fcId, $ori_type); //寫進運作
                    } else {
                        $newFcId = $this->factory_chem->store($data)->id;
                        $bottle['id'] = $newFcId;
                        $data['operate_date'] = $data['add_date'];
                        $this->chem_op->operation($data, $newFcId, $ori_type); //寫進運作
                    }
                    $newSerials[] = $bottle['serial_num'];
                }
                $del_factory_id = $this->factory_chem->delBottle($data['ord_id'], $newSerials);
                $this->chem_op_Res->destory($del_factory_id);


                DB::commit();
                return true;
            } catch (\Exception $e) {
                DB::rollBack();
                throw $e;
            }
        }
        DB::beginTransaction();
        try {
            $data['created_user'] = $user_id;
            $data['updated_user'] = $user_id;
            $data['company_id'] = $company_id;
            $data['conc'] = 0;
            $data['bottle_type']=0;
            $data['chemical_id']=0;

            //取得核可化學品
            // $chem_doc_list = $this->doc_list->chemFindDoc($data['chemical_id'], $data['add_date']);
            // if ($chem_doc_list) {
            //     if (!($chem_doc_list->conc_low <= $data['conc'] && $data['conc'] <= $chem_doc_list->conc_up)) {
            //         throw new Exception('超出濃度範圍');
            //     }
            // }

            $ordId = $this->ord->store($data);
            $type = $data['ord_type'];
            $this->chem_change->Add($data, $ordId->id, $type);

            // 檢查 blends 第一筆的 cas_no 與 conc 是否有填寫
            if (
                isset($data['blends'][0]) &&
                (empty($data['blends'][0]['cas_no']) || empty($data['blends'][0]['conc']))
            ) {
                throw new Exception("請填寫混合物 CAS No 與濃度");
            }

            //混合物
            if (isset($data['blends'][0]['cas_no'])) {
                $blends = $data['blends'];
                $insertData = [];
                foreach ($blends as $blend) {
                    if (!isset($blend['cas_no'])) {
                        continue;
                    }
                    $blend['ord_id'] = $ordId->id;
                    $insertData[] = $blend;
                }
                $this->chem_mix->store($insertData);
            }

            //工廠化學品
            if ($data['bottleCount'] > 0) {
                $data['ord_id'] = $ordId->id;
                $data['ori_weight'] = $data['weight'];
                $data['now_weight'] = $data['weight'];

                foreach ($data['bottles'] as $bottle) {
                    if (!isset($bottle['serial_num'])) {
                        throw new Exception("請填寫瓶編號");
                    }
                    $data['serial_num'] = $bottle['serial_num'];
                    $data['expired_date'] = $bottle['expired_date'];
                    $fcId = $this->factory_chem->store($data)->id;
                    $data['operate_date'] = $data['add_date'];
                    $this->chem_op->operation($data, $fcId, $type); //寫進運作
                }
            }

            DB::commit();
            return $ordId->id;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    function chemAddDestory(array $ids)
    {

        $user = auth()->user();
        $invalid = [];
        //檢查化學品是否使用過
        foreach ($ids as $id) {
            if (!$this->factory_chem->canDestory($id)) {
                $data = $this->ord->find($id);
                array_push($invalid, $data->cas_no);
            }
        }
        if (!empty($invalid)) {
            return [
                'error' => '以下化學品無法刪除' . implode(', ', $invalid),
            ];
        }
        foreach ($ids as $id) {
            $data = $this->ord->find($id);
            if ($data->company_id !== $user->belongs_parent && $data->company_id !== $user->id) {
                return [
                    'error' => "未授權刪除化學品"
                ];
            }
            $data->ord_id = $data->id;
            $this->chem_op->destory($data);
            $this->chem_change->destory($data);
            $this->chem_mix->destory($id);
            $this->factory_chem->destory($id);
            $this->ord->destory($id);
        }

        return true;
    }
    public $hasValidationErrors = false;
    public $validateOrdResult = [];
    public $validateSerialResult = [];
    public $validateMixResult = [];
    function import($request)
    {
        $import = new ChemicalOrdImport;
        Excel::import($import, $request->file('file')); // 開始匯入
        $firstSheetRows = $import->sheetOne->rows;
        $secondSheetRows = $import->sheetTwo->rows;
        $threeSheetRows = $import->sheetThree->rows;
        foreach ($firstSheetRows as $rowIndex => $firstRow) {
            if ($rowIndex === 0) {
                $firstRow[27] = '處理結果';
                $this->validateOrdResult[] = $firstRow;

                // 處理 secondSheetRows 和 threeSheetRows 的 Header
                if (isset($secondSheetRows[0])) {
                    $secondSheetRows[0][3] = '處理結果';
                    $this->validateSerialResult[] = $secondSheetRows[0];
                }
                if (isset($threeSheetRows[0])) {
                    $threeSheetRows[0][3] = '處理結果';
                    $this->validateMixResult[] = $threeSheetRows[0];
                }
                continue;
            }
            $matchingRows = $secondSheetRows->filter(function ($secondRow, $index) use ($rowIndex) {
                return $index !== 0 && (int)($secondRow[0]) == $rowIndex;
            });
            $this->importOrdValidate($firstRow, count($matchingRows));

            foreach ($matchingRows as $index => $secondRow) {
                $this->serialNumValidate($secondRow);
            }

            $matchThreeRows = $threeSheetRows->filter(function ($threeRow, $index) use ($rowIndex) {
                return $index !== 0 && (int)($threeRow[0]) == $rowIndex;
            });
            foreach ($matchThreeRows as $index => $threeRow) {
                $this->MixValidate($threeRow);
            }
        }
        if ($this->hasValidationErrors) {
            // 回傳所有驗證結果
            return [
                'status' => 'error',
                'ord' => $this->validateOrdResult,
                'serial' => $this->validateSerialResult,
                'mix' => $this->validateMixResult,
            ];
        }
        DB::beginTransaction();
        try {
            foreach ($firstSheetRows as $index => $firstRow) {
                if ($index === 0) {
                    continue;
                }
                $chemicalOrd = $this->importOrd($firstRow);
                $matchingRows = $secondSheetRows->filter(function ($secondRow, $rowIndex) use ($index) {
                    if ($rowIndex === 0) {
                        return true;
                    }
                    return (int)($secondRow[0]) == $index;
                });
                foreach ($matchingRows as $index2 => $secondRow) {
                    if ($index2 === 0) {
                        continue;
                    }
                    $this->importfactoryChem($chemicalOrd, $secondRow);
                }
                $matchThreeRows = $threeSheetRows->filter(function ($threeRow, $rowIndex) use ($index) {
                    if ($rowIndex === 0) {
                        return true;
                    }
                    return (int)($threeRow[0]) == $index;
                });
                foreach ($matchThreeRows as $index3 => $threeRow) {
                    if ($index3 === 0) {
                        continue;
                    }
                    $this->importordMix($chemicalOrd, $threeRow);
                }
            }
            DB::commit();
            return ['status' => 'success'];
        } catch (\Exception $e) {
            DB::rollBack();
            return ['status' => 'fail', 'message' => $e->getMessage()];
        }
    }

    protected function importOrd($row)
    {
        $user = Auth::user();
        // $bottle_type = $row[0] === '化學品' ? 'C' : 'B';
        $chemical_id = null;
        $unit = $row[4] === '公斤' ?'kg':'L';
        $ord_type = $row[16] === '盤點增加' ? 'J' : ($row[16] === '新購買' ? 'A' : ($row[16] === '轉入' ? 'K' : 'C'));
        $custodian = $this->user->chNameFind($row[17], $user)->id;
        $add_date = Carbon::parse($row[0])->toDateString();
        $supplier_id = $this->supply->taxFind($row[18], $user)->id;
        $state = $row[20] === '固態' ? 's' : ($row[15] === '液態' ? 'l' : 'g');
        $level = $row[21] === '試藥級' ? 'R' : 'I';
        $factory_id = $this->factory->checkFactoryName($row[11], $user)->id;
        $build_id = $this->factory->checkBdingName($row[12], $factory_id)->id;
        $area_id = $this->factory->checkAreaName($row[13], $build_id)->id;
        $use_factory = $this->factory->checkFactoryName($row[5], $user)->id;
        $use_build = $this->factory->checkBdingName($row[6], $use_factory)->id;
        $use_area = $this->factory->checkAreaName($row[7], $use_build)->id;
        $remark = $row[16] === '盤點增加' ? '盤點增加' : ($row[16] === '新購買' ? '新增化學品' : ($row[16] === '轉入' ? '轉入' : '製造'));
        $chemicalOrd = $this->ord->store([
            'add_date' => $add_date,
            'cas_no' => $row[1],
            'chemical_name'=>$row[2],
            'chemical_other'=>$row[3],
            'unit'=>$unit,
            'use_factory'=>$use_factory,
            'use_build'=>$use_build,
            'use_area'=>$use_area,
            'use_avg'=>$row[8],
            'use_max'=>$row[9],
            'use_user'=>$row[10],
            'ord_type' => $ord_type,
            'custodian' => $custodian,
            'supplier_id' => $supplier_id,
            'ship_no' => $row[14],
            'chemical_id' => $chemical_id,
            'state' => $state,
            'level' => $level,
            'brand' => $row[22],
            'weight' => $row[23],
            'bottleCount' => $row[24],
            'factory_id' => $factory_id,
            'build_id' => $build_id,
            'area_id' => $area_id,
            'store_avg'=>$row[14],
            'store_max'=>$row[15],
            'remark' => $row[26],
            'packag_unit'=>$row[25],
            'company_id' => UserHelper::getCompanyId(),
            'created_user' => $user->id,
            'updated_user' => $user->id,
        ]);
        $this->chem_change->Add($chemicalOrd->toArray(), $chemicalOrd['id'], $chemicalOrd['ord_type']);
        return $chemicalOrd;
    }

    protected function importfactoryChem($chemicalOrd, $row)
    {
        $factory_chem = $this->factory_chem->store([
            'ord_id' => $chemicalOrd['id'],
            'chemical_name'=>$chemicalOrd['chemical_name'],
            'chemical_other'=>$chemicalOrd['chemical_other'],
            'serial_num' => $row[1],
            'chemical_id' => $chemicalOrd['chemical_id'],
            'cas_no' => $chemicalOrd['cas_no'],
            'custodian' => $chemicalOrd['custodian'],
            'state' => $chemicalOrd['state'],
            'conc' => $chemicalOrd['conc'],
            'level' => $chemicalOrd['level'],
            'now_weight' => $chemicalOrd['weight'],
            'ori_weight' => $chemicalOrd['weight'],
            'expired_date' => Carbon::parse($row[2])->toDateString(),
            'factory_id' => $chemicalOrd['factory_id'],
            'build_id' => $chemicalOrd['build_id'],
            'area_id' => $chemicalOrd['area_id'],
            'company_id' => $chemicalOrd['company_id'],
            'created_user' => $chemicalOrd['created_user'],
            'updated_user' => $chemicalOrd['updated_user']
        ]);
        $merge = array_merge(
            $factory_chem->toArray(),
            [
                'supplier_id' => $chemicalOrd['supplier_id'],
                'weight' => $factory_chem['ori_weight'],
                'operate_date' => $chemicalOrd['add_date'],
            ]
        );
        $this->chem_op->operation($merge, $chemicalOrd['id'], $chemicalOrd['ord_type']);
    }

    protected function importordMix($chemmicalOrd, $row)
    {
        $this->chem_mix->create([
            'chemical_id' => $chemmicalOrd['chemical_id'],
            'ord_id' => $chemmicalOrd['id'],
            'cas_no' => $row[1],
            'conc' => $row[2],
        ]);
    }

    protected function importOrdValidate($row, $bottleCount)
    {
        $errors = [];
        // 先進行資料驗證
        $fieldErrors = $this->validateRow($row);
        $user = Auth::user();
        if ($row[17]) {
            $custodians = $this->user->chNameFind($row[17], $user);
            if (!$custodians) {
                $errors[] = "找不到保管人 {$row[17]}";
            } else {
                $custodian = $custodians->id;
            }
        }
        if (is_numeric($row[0]) && $row[0] > 0 && $row[0] < 2958466) {

            $excel_serial_date = (int) $row[0];

            $unix_timestamp = ($excel_serial_date - 25569) * 86400;


            if ($unix_timestamp > 0) {
                $add_date = date('Y-m-d', $unix_timestamp);
            } else {

                $errors[] = "日期欄位數值錯誤，無法轉換為有效日期";
            }
        } else {

            if (!preg_match('/^(19|20)\d{2}[\/\-](0?[1-9]|1[0-2])[\/\-](0?[1-9]|[12]\d|3[01])$/', $row[0])) {

                $errors[] = "日期格式錯誤(西元YYYY-MM-DD)或請日期欄位請使用文字格式";
            } else {

                $add_date = Carbon::parse($row[0])->toDateString();
            }
        }

        if($row[4]){
            if(!in_array($row[4],['公斤','公升']))
            {
                $error[] = "單位只能是'公斤'或是'公升'";
            }
        }
        if ($row[25]) {
            if (!in_array($row[25], ['瓶', '袋', '桶', '包', '罐'])) {
                $errors[] = "分裝單位只能是'瓶'、'袋'、'桶'、'包'、'罐'";
            }
        }
        if ($row[18]) {
            $supplier = $this->supply->taxFind($row[18]);
            if (!$supplier) {
                $errors[] = "找不到供應商 {$row[18]}";
            } else {
                if ($row[16] === '輸入' && $supplier->country !== '國外') {
                    $errors[] = "輸入廠商需選擇國外廠商";
                } else if (($row[16] === "新購買" || $row[16] === "轉入") && $supplier->country !== "國內") {
                    $errors[] = "購買or轉入廠商需選擇國內廠商";
                } else {
                    $supplier_id = $supplier->id;
                }
            }
        }
        if ($row[20]) {
            if ($row[20] === '固態') {
                $state = 's';
            } elseif ($row[20] === '液態') {
                $state = 'l';
            } elseif ($row[20] === '氣態') {
                $state = 'g';
            } else {
                $errors[] = "找不到物質狀態";
            }
        }
        if ($row[21]) {
            if ($row[21] === '試藥級') {
                $level = 'R';
            } elseif ($row[21] === '工業級') {  // 這裡應該是工業級吧？
                $level = 'I';
            } else {
                $errors[] = "找不到化學品等級";
            }
        }
        if (isset($row[23]) && !is_numeric($row[23])) {
            $errors[] = "重量不是數字";
        }
        if ($bottleCount != $row[24]) {
            $errors[] = "瓶數量與瓶編號頁籤數量不對";
        }
        if ($row[16]) {
            if (!in_array($row[16],['盤點增加','新購買','轉入','製造','輸入'])) {
                $errors[] = "找不到新增類型";
            }
        }
        if ($row[11]) {
            $factory = $this->factory->checkFactoryName($row[11], $user);
            if (!$factory) {
                $errors[] = "貯存工廠找不到{$row[11]}";
            } else {
                $factory_id = $factory->id;
                // if ($factory_id && ($chemical->toxic_moenv || $chemical->concerned)) {
                //     $company_id = UserHelper::getCompanyId();
                //     $docLists = ApprovalDocList::where('chemical_id', $chemical_id)
                //         ->where('approval_doc_lists.company_id', $company_id)
                //         ->where('end_date', '>=', now())
                //         ->rightJoin('approval_docs', 'approval_doc_lists.doc_id', '=', 'approval_docs.id')
                //         ->get();

                //     if (!$docLists->isEmpty()) {
                //         $foundValidFactoryAndConc = false;
                //         foreach ($docLists as $docList) {
                //             if ($row[2] === '新購買' || $row[2] === '盤點增加') {
                //                 continue;
                //             }
                //             if ($docList->start_date <= $row[1] && $docList->end_date >= $row[1]) {
                //                 // 先檢查 factory_id 是否相符
                //                 if ($docList->factory_id == $factory_id) {
                //                     // 再檢查濃度是否在允許範圍內
                //                     if ($row[8] >= $docList->conc_low && $row[8] <= $docList->conc_up) {
                //                         $foundValidFactoryAndConc = true; // 找到匹配的 factory_id 和 conc
                //                         // 開始檢查 type
                //                         if ($row[2] === '轉入' && !$docList->type_shift_in) {
                //                             $errors[] = "無販賣核可";
                //                         } else if ($row[2] === '製造' && !$docList->type_make) {
                //                             $errors[] = "無製造許可";
                //                         } else if ($row[2] === '輸入' && !$docList->type_import) {
                //                             $errors[] = "無輸入許可";
                //                         }
                //                         break; // 找到符合條件的就不需要繼續檢查其他 docList
                //                     } else {
                //                         $errors[] = "濃度超過許可範圍";
                //                     }
                //                 }
                //             } else {
                //                 $errors[] = "購買日期未在核可證書的有效期間內。";
                //             }
                //         }
                //     }
                //     if (!$foundValidFactoryAndConc && ($docList->start_date <= $row[1] && $docList->end_date >= $row[1])) {
                //         $errors[] = "化學品在此廠區無運作核可";
                //     }
                // }
                if ($row[12]) {
                    $build = $this->factory->checkBdingName($row[12], $factory_id);
                    if (!$build) {
                        $errors[] = "貯存棟別找不到{$row[12]}";
                    } else {
                        $build_id = $build->id;
                        if ($row[13]) {
                            $area = $this->factory->checkAreaName($row[13], $build_id);
                            if (!$area) {
                                $errors[] = "貯存儲存區找不到{$row[13]}";
                            } else {
                                $area_id = $area->id;
                            }
                        }
                    }
                }
            }
        }
        if ($row[5]) {
            $factory = $this->factory->checkFactoryName($row[5], $user);
            if (!$factory) {
                $errors[] = "使用工廠找不到{$row[5]}";
            } else {
                $factory_id = $factory->id;
                if ($row[6]) {
                    $build = $this->factory->checkBdingName($row[6], $factory_id);
                    if (!$build) {
                        $errors[] = "使用棟別找不到{$row[6]}";
                    } else {
                        $build_id = $build->id;
                        if ($row[7]) {
                            $area = $this->factory->checkAreaName($row[7], $build_id);
                            if (!$area) {
                                $errors[] = "使用儲存區找不到{$row[7]}";
                            } else {
                                $area_id = $area->id;
                            }
                        }
                    }
                }
            }
        }
        // $remark = $row[2] === '盤點增加' ? '盤點增加' : ($row[2] === '新購買' ? '新增化學品' : ($row[2] === '轉入' ? '轉入' : '製造'));
        // 若驗證通過，則不做任何事，後續進行創建
        $Allerrors = array_merge($fieldErrors, $errors);
        if (!empty($Allerrors)) {
            $this->hasValidationErrors = true;
            $row[27] = implode("、", $Allerrors);
        } else {
            // 若驗證通過，設定成功訊息
            $row[27] = '無錯誤';
        }
        $this->validateOrdResult[] = $row;
    }
    // 檢查每一行資料
    private function validateRow($row)
    {
        $errors = [];

        // 欄位名稱對應與錯誤訊息
        $fields = [
            0 => '日期欄位',
            1 => '索引碼',
            2 => '化學品名稱',
            4 => '單位',
            5 => '使用工廠',
            6 => '使用棟別',
            7 => '使用儲存區',
            8 => '使用資料(平均)',
            9 => '使用資料(最大)',
            10 => '使用資料(使用者)',
            11 => '貯存工廠',
            12 => '貯存棟別',
            13 => '貯存儲存區',
            14 => '貯存資料(平均)',
            15 => '貯存資料(最大)',
            16 => '新增類型',
            17 => '保管人',
            20 => '物質狀態',
            21 => '化學品等級',
            25 => '分裝單位'
        ];
        if (in_array($row[16], ['新購買', '轉入', '輸入']) && empty($row[18])) {
            $errors[] = "供應商統一編號不可為空";
        }

        foreach ($fields as $index => $field) {
            if (empty($row[$index])) {
                $errors[] = "{$field}不可為空";
            }
        }

        // 返回錯誤訊息陣列
        return $errors;
    }

    protected function serialNumValidate($row)
    {
        $validationErrors = [];
        static $seenValues = []; // 儲存不同 $row[0] 的瓶編號

        // 確保 $row[0] 是有效的 key
        if (!isset($seenValues[$row[0]])) {
            $seenValues[$row[0]] = [];
        }

        // 檢查瓶編號是否為空
        if (empty($row[1])) {
            $validationErrors[] = "瓶編號不可為空";
        }

        // 檢查到期日是否為空
        if (empty($row[2])) {
            $validationErrors[] = "到期日不可為空";
        }

        // 檢查瓶編號是否重複 (以 $row[0] 分組)
        if (in_array($row[1], $seenValues[$row[0]])) {
            $validationErrors[] = "瓶編號 {$row[1]} 在編號 {$row[0]} 下重複";
        } else {
            $seenValues[$row[0]][] = $row[1]; // 加入已出現的值
        }

        // 檢查日期格式
        try {
            $add_date = Carbon::parse($row[2])->toDateString();
        } catch (\Exception $e) {
            $validationErrors[] = "日期格式錯誤(YYYY-MM-DD)";
        }

        // 處理錯誤訊息
        if (!empty($validationErrors)) {
            $this->hasValidationErrors = true;
            $row[4] = implode("、", $validationErrors);
        } else {
            $row[4] = ''; // 清空錯誤訊息
        }

        $this->validateSerialResult[] = $row;
    }

    protected function MixValidate($row)
    {
        $validationErrors = [];
        if ($row[1]) {
            $chemical = $this->Chemical->findcas($row[1]);
            if (!$chemical) {
                $validationErrors[] = "CasNo {$row[2]} 不存在";
            }
        }
        // 新增 $row[2] 格式檢查
        if (isset($row[2]) && $row[2] !== '') {
            $value = $row[2];
            // 允許的格式：數字、1~10、<10、>10
            if (!preg_match('/^\d+(\.\d+)?$|^\d+(\.\d+)?~\d+(\.\d+)?$|^<\d+(\.\d+)?$|^>\d+(\.\d+)?$/', $value)) {
                $validationErrors[] = "濃度格式錯誤，僅允許數字、範圍(1~10)、<數字、>數字";
            }
        }
        
        if (!empty($validationErrors)) {
            $this->hasValidationErrors = true;
            $row[3] = implode("、", $validationErrors);
        } else {
            $row[3] = '';
        }
        $this->validateMixResult[] = $row;
    }
}
