<?php

namespace App\Imports;

use App\Models\Chemical;
use App\Models\ChemicalBase;
use Exception;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Imports\HeadingRowFormatter;

HeadingRowFormatter::default('none');
class ChemicalImport implements WithHeadingRow, WithMultipleSheets
{
    public $sheetOne;
    public $sheetTwo;

    public function __construct()
    {
        $this->sheetOne = new SheetOneImport();
        $this->sheetTwo = new SheetTwoImport();
    }

    public function sheets(): array
    {
        return [
            '匯入表' => $this->sheetOne,
        ];
    }
}

class SheetOneImport implements ToCollection
{
    public $rows;
    // public function __construct($importer)
    // {
    //     $this->importer = $importer;
    // }

    public function collection(Collection $collection)
    {

        foreach ($collection as $index=>$row) {
            if($index ===0){
                continue;
            }
            if (empty($row[0])) {
                throw new Exception("cas_no不可為空", 400);
            }
            if (empty($row[2])) {
                throw new Exception("英文品名不可為空", 400);
            }
            $casNo = $row[0];
            $existingChemical = Chemical::where('cas_no', $casNo)->first();
            if (!$existingChemical) {
                Chemical::create([
                    'cas_no' => trim($row[0]) ?? null,
                    'ch_name' => trim($row[1]) ?? null,
                    'en_name' => str_replace(["\n","\r"],'',trim($row[2]))  ?? null,
                    'hazards' => $this->convertYN($row[3]) ?? null,
                    'priority' => $this->convertYN($row[4]) ?? null,
                    'list_priority' => $this->convertYN($row[5]) .
                        $this->convertYN($row[6]) .
                        $this->convertYN($row[7]) .
                        $this->convertYN($row[8]),
                    'control' => $this->convertYN($row[9]) ?? null,
                    'pioneer' => $this->convertYN($row[10]) ?? null,
                    'water_poll' => $this->convertYN($row[11]) ?? null,
                    'concerned' => $this->convertYN($row[12]) ?? null,
                    'list_concerned' => $this->convertYN($row[13]) ?? null,
                    'toxic_moenv' => $this->convertYN($row[14]) ?? null,
                    'listNo' => $row[15] ?? null,
                    'toxic_class' => $this->convertYN($row[16]) . $this->convertYN($row[17]) . $this->convertYN($row[18]) . $this->convertYN($row[19])  ?? '0000',
                    'conc' => $row[20] ?? null,
                    'graded' => $row[21] ?? null,
                    'boil' => $row[22] ?? null,
                    'melt' => $row[23] ?? null,
                    'formula' => $row[24] ?? null,
                    'molecular' => $row[25] ?? null,
                    'ingredient' => $row[26] ?? null,
                    'pub_hazard' => $this->convertYN($row[27]) ?? null,
                    'solv' => $this->convertYN($row[28]) ?? null,
                    'monitor' => $this->convertYN($row[29]) ?? null,
                    'chem_spec' => $this->convertYN($row[30]) ?? null,
                    'lead' => $this->convertYN($row[31]) ?? null,
                    'four_lead' => $this->convertYN($row[32]) ?? null,
                    'ccd_health' => $this->convertYN($row[33]),
                    'expose_conc' => $this->convertYN($row[34]) ?? null,
                    'pel_solide' => $row[35] ?? null,
                    'pel_liquid' => $row[36] ?? null,
                    'a201' => $row[37] === '不穩定爆炸物' ? '1' : ($row[37] === '1.1組' ? '2' : ($row[37] === '1.2組' ? '3' : ($row[37] === '1.3組' ? '4' : ($row[37] === '1.4組' ? '5' : ($row[37] === '1.5組' ? '6' : ($row[37] === '1.6組' ? '7' : '')))))),
                    'a202' => $row[38],
                    'a203' => $row[39],
                    'a204' => $row[40],
                    'a205' => $row[41] === '壓縮氣體' ? '1' : ($row[41] === '液化氣體' ? '2' : ($row[41] === '冷凍液化氣體' ? '3' : ($row[41] === '溶解氣體' ? '4' : ''))),
                    'a206' => $row[42],
                    'a207' => $row[43],
                    'a208' => $row[44] === 'A型' ? '1' : ($row[44] === 'B型' ? '2' : ($row[44] === 'C型' ? '3' : ($row[44] === 'D型' ? '4' : ($row[44] === 'E型' ? '5' : ($row[44] === 'F型' ? '6' : ($row[44] === 'G型' ? '7' : '')))))),
                    'a209' => $row[45],
                    'a210' => $row[46],
                    'a211' => $row[47],
                    'a212' => $row[48],
                    'a213' => $row[49],
                    'a214' => $row[50],
                    'a215' => $row[51] === 'A型' ? '1' : ($row[51] === 'B型' ? '2' : ($row[51] === 'C型' ? '3' : ($row[51] === 'D型' ? '4' : ($row[51] === 'E型' ? '5' : ($row[51] === 'F型' ? '6' : ''))))),
                    'a216' => $row[52],
                    'a217' => $row[53],
                    'a217a' => $row[54] === '無此危害分類' ? '1' : ($row[54] === '第1級' ? '2' : ($row[54] === '第2級' ? '3' : ($row[54] === '第3級' ? '4' : ($row[54] === '第4級' ? '5' : ($row[54] === '第5級' ? '6' : ''))))),
                    'a217b' => $row[55] === '無此危害分類' ? '1' : ($row[55] === '第1級' ? '2' : ($row[55] === '第2級' ? '3' : ($row[55] === '第3級' ? '4' : ($row[55] === '第4級' ? '5' : ($row[55] === '第5級' ? '6' : ''))))),
                    'a217c' => $row[56] === '無此危害分類' ? '1' : ($row[56] === '第1級' ? '2' : ($row[56] === '第2級' ? '3' : ($row[56] === '第3級' ? '4' : ($row[56] === '第4級' ? '5' : ($row[56] === '第5級' ? '6' : ''))))),
                    'a218' => $row[57],
                    'a219' => $row[58],
                    'a220' => $row[59],
                    'a221' => $row[60],
                    'a222' => $row[61] === '1A' ? '1' : ($row[61] === '1B' ? '2' : ($row[61] === '2' ? '3' : '')),
                    'a223' => $row[62] === '1A' ? '1' : ($row[62] === '1B' ? '2' : ($row[62] === '2' ? '3' : '')),
                    'a224a' => $row[63] === '1A' ? '1' : ($row[63] === '1B' ? '2' : ($row[63] === '2' ? '3' : '')),
                    'a224b' => $row[64] === '特殊級別' ? '1' : '',
                    'a225' => $row[65],
                    'a225a' => $row[66],
                    'a226' => $row[67],
                    'a226a' => $row[68],
                    'a227' => $row[69],
                    'a228' => $row[70],
                    'a229' => $row[71],
                    'transport_icon' => $this->convertYN($row[72])
                        . $this->convertYN($row[73])  . $this->convertYN($row[74])
                        . $this->convertYN($row[75]) . $this->convertYN(76) . $this->convertYN($row[77]) . $this->convertYN($row[78])
                        . $this->convertYN($row[79])
                        . $this->convertYN($row[80]) . $this->convertYN($row[81]) . $this->convertYN($row[82]) . $this->convertYN($row[83])
                        . $this->convertYN($row[84]) . $this->convertYN($row[85]) . $this->convertYN($row[86]) . $this->convertYN($row[87])
                        . $this->convertYN($row[88])
                        . $this->convertYN($row[89]) . $this->convertYN($row[90]) . $this->convertYN($row[91]) . $this->convertYN($row[92])
                        . $this->convertYN($row[93]) . $this->convertYN($row[94])  ?? null,
                ]);
            } else {
                throw new Exception("cas_no重複", 400);
            }
        }
    }

    private function convertYN($value)
    {
        return strtoupper($value ?? '') === 'Y' ? 1 : 0;
    }


    private function convertBool($value)
    {
        $postion = strpos($value, '1');

        if ($postion !== false) {
            return $postion + 1;
        }
        return 0;
    }

    private function onecheck($values)
    {
        $values = array_map([$this, 'convertYN'], $values); // 轉換 Y/N 為 1/0
        return array_sum($values) === 1 ? 1 : 0; // 檢查是否只有一個 1
    }
}

class SheetTwoImport implements ToCollection
{
    public $rows;

    // public function __construct($importer)
    // {
    //     $this->importer = $importer;
    // }

    // 處理第二個工作表的資料
    public function collection(Collection $collection)
    {
        // $this->importer->processSecondSheet($collection);
        $this->rows = $collection;
    }
}
