<?php

namespace App\Imports;

use App\Models\Chemical;
use App\Models\ChemicalBase;
use Exception;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Imports\HeadingRowFormatter;

HeadingRowFormatter::default('none');
class ChemicalImportPriority implements WithHeadingRow, WithMultipleSheets
{
    public $sheetOne;
    public $sheetTwo;

    public function __construct()
    {
        $this->sheetOne = new SheetOneImport();
        $this->sheetTwo = new SheetTwoImport();
    }

    public function sheets(): array
    {
        return [
            'Table' => $this->sheetOne,
        ];
    }
}

class SheetOneImport implements ToCollection
{
    public $rows;
    // public function __construct($importer)
    // {
    //     $this->importer = $importer;
    // }

    public function collection(Collection $collection)
    {

        foreach ($collection as $index=>$row) {
            if($index ===0){
                continue;
            }
            $casNo = $row[0];
            $existingChemical = Chemical::where('cas_no', $casNo)->first();
            if (!$existingChemical) {
                Chemical::create([
                    'cas_no' => trim($row[0]),
                    'ch_name' => trim($row[2]) ?? null,
                    'en_name' => str_replace(["\r","\n"],'',trim($row[1])) ,
                    'toxic_moenv' => 0,
                    'hazards' => 0,
                    'priority' => 1,
                    'control' =>0,
                    'pioneer' => 0,
                    'water_poll' => 0,
                    'concerned' => 0,
                    'pub_hazard' => 0,
                    'solv' => 0,
                    'monitor' => 0,
                    'chem_spec' => 0,
                    'lead' => 0,
                    'four_lead' => 0,
                    'ccd_health' => 0,
                    'expose_conc' => 0,
                    'danger'=>0,
                    'danger_water'=>0,
                    'list_priority'=>'0000',
                    'listNo' => '',
                    'toxic_class' => '0000',
                    'conc' => '',
                    'graded' => '',
                    'formula' => '',
                    'transport_icon'=>'00000000000000000000000'
                ]);
            } else {
                $existingChemical->update([
                    'priority' => 1,
                    'danger'=>$existingChemical->danger ?? 0,
                    'danger_water'=>$existingChemical->danger_water ?? 0,
                ]);
            }
        }
    }

    private function convertYN($value)
    {
        return strtoupper($value ?? '') === 'Y' ? 1 : 0;
    }
    function convertToBinaryString($input) {
        $numbers = explode(",", $input); // 以逗號分割字串
        $binary = 0;
    
        foreach ($numbers as $num) {
            $binary |= (1 << (4 - intval($num))); // 讓對應的 bit 設為 1
        }
    
        return str_pad(decbin($binary), 4, "0", STR_PAD_LEFT);
    }

    private function convertBool($value)
    {
        $postion = strpos($value, '1');

        if ($postion !== false) {
            return $postion + 1;
        }
        return 0;
    }

    private function onecheck($values)
    {
        $values = array_map([$this, 'convertYN'], $values); // 轉換 Y/N 為 1/0
        return array_sum($values) === 1 ? 1 : 0; // 檢查是否只有一個 1
    }
}

class SheetTwoImport implements ToCollection
{
    public $rows;

    // public function __construct($importer)
    // {
    //     $this->importer = $importer;
    // }

    // 處理第二個工作表的資料
    public function collection(Collection $collection)
    {
        // $this->importer->processSecondSheet($collection);
        $this->rows = $collection;
    }
}
