<?php

namespace App\Imports;

use App\Exports\ChemicalErrorExport;
use App\Helpers\UserHelper;
use App\Models\ApprovalDocList;
use App\Models\Chemical;
use App\Models\Chemical_mix;
use App\Models\Chemical_operation;
use App\Models\Chemical_ord;
use App\Models\Chemical_ord_log;
use App\Models\Factory;
use App\Models\Factory_area;
use App\Models\Factory_bding;
use App\Models\Factory_chemical;
use App\Models\Supply;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Imports\HeadingRowFormatter;

HeadingRowFormatter::default('none');
class ChemicalOrdImport implements WithMultipleSheets
{

    protected $firstSheetIndexes = [];
    protected $failedRows = [];
    protected $allValid = true;
    public $sheetOne;
    public $sheetTwo;
    public $sheetThree;

    public function __construct()
    {
        $this->sheetOne = new SheetOneImport();
        $this->sheetTwo = new SheetTwoImport();
        $this->sheetThree = new SheetThreeImport();
    }
    // 定義處理多工作表
    public function sheets(): array
    {
        return [
            '購買資料' => $this->sheetOne,
            '瓶編號' => $this->sheetTwo,
            '混合物質' => $this->sheetThree,
        ];
    }

    public function getExportData(): array
    {
        return $this->failedRows;
    }
    public function getallValid()
    {
        return $this->allValid;
    }

    /**
     * @param Collection $collection
     */
    public function processFirstSheet(Collection $collection)
    {
        $validationErrors = []; // 儲存有錯誤的資料
        // 使用頁籤一的資料
        foreach ($collection as $index => $row) {
            if ($index === 0) {
                $row[17] = '處理結果';
                $validationErrors[] = $row;
                continue;
            }
            try {
                $errors = [];
                // 先進行資料驗證
                $fieldErrors = $this->validateRow($row);
                $user = Auth::user();
                $bottle_type = $row[0] === '化學品' ? 'C' : ($row[0] === '鋼瓶' ? 'B' :  $errors[] = "找不到請購類別");
                if ($row[6]) {
                    $chemical = Chemical::where('cas_no', $row[6])->first();
                    if (!$chemical) {
                        $errors[] = "CAS號 {$row[6]} 不存在";
                    } else {
                        $chemical_id = $chemical->id;
                    }
                }
                if ($row[3]) {
                    $custodians = User::where('belongs_parent', UserHelper::getCompanyId())
                        ->where('name', $row[3])->first();
                    if (!$custodians) {
                        $errors[] = "找不到保管人 {$row[3]}";
                    } else {
                        $custodian = $custodians->id;
                    }
                }
                try {
                    $add_date = Carbon::parse($row[1])->toDateString();
                } catch (\Exception $e) {
                    $errors[] = "日期格式錯誤 {$row[1]}";
                }
                $state = $row[7] === '固態' ? 's' : ($row[7] === '液態' ? 'l' : ($row[7] === '氣態' ? 'g' : $errors[] = "找不到物質狀態"));
                $level = $row[9] === '試藥級' ? 'R' : ($row[9] === '試藥級' ? 'I' : $errors[] = "找不到化學品等級");

                if ($row[13]) {
                    $factory = Factory::where('company_id', UserHelper::getCompanyId())
                        ->where('name', $row[13])->first();
                    if (!$factory) {
                        $errors[] = "找不到{$row[13]}";
                    } else {
                        $factory_id = $factory->id;
                        if ($factory_id) {
                            $company_id = User::where('belongs_parent', UserHelper::getCompanyId());
                            $docLists = ApprovalDocList::where('chemical_id', $chemical_id)
                                ->where('factory_id', $factory_id)
                                ->where('company_id', $company_id)
                                ->where('end_date', '>=', now())
                                ->rightJoin('approval_docs', 'ApprovalDocList.doc_id', '=', 'approval_docs.id')
                                ->rightJoin('chemicals', 'ApprovalDocList.chemical_id', '=', 'approval_docs.chemical_id')
                                ->get();
                            foreach ($docLists as $docList) {
                                if ($row[2] === '轉入' && !$docList->type_shift_in && ($docList->toxic_moenv || $docList->concerned)) {
                                    $errors[] = "無販賣核可";
                                } else if ($row[2] === '製造' && !$docList->type_make && ($docList->toxic_moenv || $docList->concerned)) {
                                    $errors[] = "無製造許可";
                                } else if ($row[2] === '輸入' && !$docList->type->import && ($docList->toxic_moenv || $docList->concerned)) {
                                    $errors[] = "無輸入許可";
                                }
                                if ($row[8] < $docList->conc_low || $row[8] >  $docList->conc_up) {
                                    $errors[] = "濃度超過許可範圍";
                                }
                            }
                        }
                        $ord_type = $row[2] === '盤點增加' ? 'J' : ($row[2] === '新購買' ? 'A' : ($row[2] === '轉入' ? 'K' : ($row[2] === '製造' ? 'C' : ($row[2] === '輸入' ? 'O' : $errors[] = "找不到類型"))));
                        if ($row[4]) {
                            $supplier = Supply::where('c_id', UserHelper::getCompanyId())
                                ->where('tax', $row[4])->first();
                            if ($row[2] === '輸入' && $supplier->country !== '國外') {
                                $errors[] = "輸入廠商需選擇國外廠商";
                            } else if ($row[2] === "新購買" || $row[2] === "轉入" && $supplier !== "國內") {
                                $errors[] = "輸入廠商需選擇國內廠商";
                            }
                            if (!$supplier) {
                                $errors[] = "找不到供應商 {$row[4]}";
                            } else {
                                $supplier_id = $supplier->id;
                            }
                        }
                        if ($row[14]) {
                            $build = Factory_bding::where('f_id', $factory_id)
                                ->where('name', $row[14])->first();
                            if (!$build) {
                                $errors[] = "找不到{$row[14]}";
                            } else {
                                $build_id = $build->id;
                                if ($row[15]) {
                                    $area = Factory_area::where('b_id', $build_id)
                                        ->where('name', $row[15])->first();
                                    if (!$area) {
                                        $errors[] = "找不到{$row[15]}";
                                    } else {
                                        $area_id = $area->id;
                                    }
                                }
                            }
                        }
                    }
                }
                $remark = $row[2] === '盤點增加' ? '盤點增加' : ($row[2] === '新購買' ? '新增化學品' : ($row[2] === '轉入' ? '轉入' : ($row[2] === '製造' ? '製造' : '輸入')));
                // 若驗證通過，則不做任何事，後續進行創建
                $row[17] = '成功';
                $Allerrors = array_merge($fieldErrors, $errors);
                if (!empty($Allerrors)) {
                    $row[17] = implode("、", $Allerrors);
                    $validationErrors[] = $row;
                } else {
                    // 若驗證通過，設定成功訊息
                    $row[17] = '成功';
                    $validationErrors[] = $row;
                    continue;
                }
            } catch (\Exception $e) {
                // 資料驗證失敗，將錯誤加入failedRows
                $row[17] = $e->getMessage();
                $validationErrors[] = $row;
            }
        }
        if (!empty($Allerrors)) {
            $this->failedRows = $validationErrors;
            $this->allValid = false;
            return;
        }
        foreach ($collection as $index => $row) {
            if ($index === 0) {
                $row[17] = '處理結果';
                $this->failedRows[] = $row;
                continue;
            } else {
                $user = Auth::user();
                $bottle_type = $row[0] === '化學品' ? 'C' : 'B';
                $chemical_id = Chemical::where('cas_no', $row[6])->first()->id;
                $ord_type = $row[2] === '盤點增加' ? 'J' : ($row[2] === '新購買' ? 'A' : ($row[2] === '轉入' ? 'K' : 'C'));
                $custodian = User::where('belongs_parent', UserHelper::getCompanyId())->where('name', $row[3])->first()->id;
                $add_date = Carbon::parse($row[1])->toDateString();
                $supplier_id = Supply::where('c_id', UserHelper::getCompanyId())->where('tax', $row[4])->first()->id;
                $state = $row[7] === '固態' ? 's' : ($row[7] === '液態' ? 'l' : 'g');
                $level = $row[9] === '試藥級' ? 'R' : 'I';
                $factory_id = Factory::where('company_id', UserHelper::getCompanyId())->where('name', $row[13])->first()->id;
                $build_id = Factory_bding::where('f_id', $factory_id)->where('name', $row[14])->first()->id;
                $area_id = Factory_area::where('b_id', $build_id)->where('name', $row[15])->first()->id;
                $remark = $row[2] === '盤點增加' ? '盤點增加' : ($row[2] === '新購買' ? '新增化學品' : ($row[2] === '轉入' ? '轉入' : '製造'));
                $chemmicalOrd = Chemical_ord::create([
                    'bottle_type' => $bottle_type,
                    'add_date' => $add_date,
                    'ord_type' => $ord_type,
                    'custodian' => $custodian,
                    'supplier_id' => $supplier_id,
                    'ship_no' => $row[5],
                    'chemical_id' => $chemical_id,
                    'cas_no' => $row[6],
                    'state' => $state,
                    'conc' => $row[8],
                    'level' => $level,
                    'brand' => $row[10],
                    'weight' => $row[11],
                    'bottleCount' => $row[12],
                    'factory_id' => $factory_id,
                    'build_id' => $build_id,
                    'area_id' => $area_id,
                    'remark' => $row[16],
                    'company_id' => UserHelper::getCompanyId(),
                    'created_user' => $user->id,
                    'updated_user' => $user->id,
                ]);
                Chemical_ord_log::create([
                    'ord_id' => $chemmicalOrd['id'],
                    'add_date' => $chemmicalOrd['add_date'],
                    'chemical_id' => $chemmicalOrd['chemical_id'],
                    'cas_no' => $chemmicalOrd['cas_no'],
                    'custodian' => $chemmicalOrd['custodian'],
                    'supplier_id' => $chemmicalOrd['supplier_id'],
                    'state' => $chemmicalOrd['state'],
                    'conc' => $chemmicalOrd['conc'],
                    'level' => $chemmicalOrd['level'],
                    'brand' => $chemmicalOrd['brand'],
                    'bottleCount' => $chemmicalOrd['bottleCount'],
                    'remark' => $remark,
                    'weight' => $chemmicalOrd['weight'],
                    'type' => $chemmicalOrd['ord_type'],
                    'factory_id' => $chemmicalOrd['factory_id'],
                    'build_id' => $chemmicalOrd['build_id'],
                    'area_id' => $chemmicalOrd['area_id'],
                    'company_id' => $chemmicalOrd['company_id'],
                    'created_user' => $chemmicalOrd['created_user'],
                    'updated_user' => $chemmicalOrd['updated_user']
                ]);
                $row[17] = '成功';
            }
        }
    }
    // 處理第二個工作表的資料
    public function processSecondSheet(Collection $collection, $sheetIndex)
    {

        $chemmicalOrd = Chemical_ord::latest()->first();
        if ($chemmicalOrd) {
            foreach ($collection as $index => $row) {
                if ($index === 0) continue; // 跳過標題列
                try {
                    if ($row[0] === $sheetIndex) {
                        $this->processPageTwo($chemmicalOrd, $row);
                    }
                } catch (\Exception $e) {
                    throw new \Exception("Error processing second sheet: " . $e->getMessage());
                }
            }
        } else {
            $validationErrors = []; // 儲存有錯誤的資料
            // 使用頁籤一的資料
            foreach ($collection as $index => $row) {
                if ($index === 0) {
                    $row[3] = '處理結果';
                    $validationErrors[] = $row;
                    continue;
                }
            }
        }
    }
    // 處理第三個工作表的資料
    public function processThirdSheet(Collection $collection)
    {
        $chemmicalOrd = Chemical_ord::latest()->first();
        foreach ($collection as $index => $row) {
            if ($index === 0) continue; // 跳過標題列

            try {
                $this->processPageThree($chemmicalOrd, $row);
            } catch (\Exception $e) {
                throw new \Exception("Error processing third sheet: " . $e->getMessage());
            }
        }
    }

    private function processPageTwo($chemmicalOrd, $row)
    {
        $factory_chem = Factory_chemical::create([
            'ord_id' => $chemmicalOrd['id'],
            'serial_num' => $row[1],
            'chemical_id' => $chemmicalOrd['chemical_id'],
            'cas_no' => $chemmicalOrd['cas_no'],
            'custodian' => $chemmicalOrd['custodian'],
            'state' => $chemmicalOrd['state'],
            'conc' => $chemmicalOrd['conc'],
            'level' => $chemmicalOrd['level'],
            'now_weight' => $chemmicalOrd['weight'],
            'ori_weight' => $chemmicalOrd['weight'],
            'expired_date' => Carbon::parse($row[2])->toDateString(),
            'factory_id' => $chemmicalOrd['factory_id'],
            'build_id' => $chemmicalOrd['build_id'],
            'area_id' => $chemmicalOrd['area_id'],
            'company_id' => $chemmicalOrd['company_id'],
            'created_user' => $chemmicalOrd['created_user'],
            'updated_user' => $chemmicalOrd['updated_user']
        ]);
        $remark = $chemmicalOrd['ord_type'] === '盤點增加' ? '盤點增加' : ($chemmicalOrd['ord_type'] === '新購買' ? '新增化學品' : ($chemmicalOrd['ord_type'] === '轉入' ? '轉入' : '製造'));
        Chemical_operation::create([
            'factory_chemical_id' => $factory_chem['id'],
            'serial_num' => $factory_chem['serial_num'],
            'chemical_id' => $factory_chem['chemical_id'],
            'cas_no' => $factory_chem['cas_no'],
            'custodian' => $factory_chem['custodian'],
            'supplier_id' => $factory_chem['supplier_id'],
            'state' => $factory_chem['state'],
            'conc' => $factory_chem['conc'],
            'level' => $factory_chem['level'],
            'brand' => $factory_chem['brand'],
            'weight' => $factory_chem['ori_weight'],
            'type' => $chemmicalOrd['ord_type'],
            'remark' => $remark,
            'factory_id' => $factory_chem['factory_id'],
            'build_id' => $factory_chem['build_id'],
            'area_id' => $factory_chem['area_id'],
            'company_id' => $factory_chem['area_id'],
            'operate_date' => $chemmicalOrd['add_date'],
            'created_user' => $factory_chem['created_user'],
            'updated_user' => $factory_chem['updated_user'],
        ]);
    }
    private function processPageThree($chemmicalOrd, $row)
    {
        Chemical_mix::create([
            'chemical_id' => $chemmicalOrd['chemical_id'],
            'ord_id' => $chemmicalOrd['id'],
            'cas_no' => $row[1],
            'conc' => $row[2],
        ]);
    }

    // 檢查每一行資料
    private function validateRow($row)
    {
        $errors = [];

        if (empty($row[1])) {
            $errors[] = "日期欄位不可為空";
        }

        if (empty($row[6])) {
            $errors[] = "CAS號碼不可為空";
        }

        if (empty($row[2])) {
            $errors[] = "訂單類型不可為空";
        }

        if (empty($row[3])) {
            $errors[] = "領用人員不可為空";
        }

        if (empty($row[4])) {
            $errors[] = "供應商稅號不可為空";
        }

        if (empty($row[7])) {
            $errors[] = "物質狀態不可為空";
        }
        if (empty($row[8])) {
            $errors[] = "濃度不可為空";
        }
        if (empty($row[9])) {
            $errors[] = "等級不可為空";
        }

        if (empty($row[13])) {
            $errors[] = "工廠名稱不可為空";
        }

        if (empty($row[14])) {
            $errors[] = "建築物名稱不可為空";
        }

        if (empty($row[15])) {
            $errors[] = "區域名稱不可為空";
        }

        // 如果有錯誤，丟出例外
        return $errors;
    }
}

class SheetOneImport implements ToCollection
{
    public $rows;

    // public function __construct($importer)
    // {
    //     $this->importer = $importer;
    // }

    // 處理第一個工作表的資料
    public function collection(Collection $collection)
    {
        // $this->importer->processFirstSheet($collection);
        $this->rows = $collection;
    }
}

class SheetTwoImport implements ToCollection
{
    public $rows;

    // public function __construct($importer)
    // {
    //     $this->importer = $importer;
    // }

    // 處理第二個工作表的資料
    public function collection(Collection $collection)
    {
        // $this->importer->processSecondSheet($collection);
        $this->rows = $collection;
    }
}

class SheetThreeImport implements ToCollection
{
    public $rows;

    // public function __construct($importer)
    // {
    //     $this->importer = $importer;
    // }

    // 處理第三個工作表的資料
    public function collection(Collection $collection)
    {
        // $this->importer->processThirdSheet($collection);
        $this->rows = $collection;
    }
}
