<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApprovalDoc extends Model
{
    use HasFactory;

    protected $fillable = [
        'per_no',
        'factory_id',
        'people',
        'start_date',
        'end_date',
        'company_id',
        'created_user',
        'updated_user'
    ];

    public function docList(){
        return $this->hasMany(ApprovalDocList::class,'doc_id');
    }

    public function docFile(){
        return $this->hasMany(ApprovalDocFile::class,'doc_id');
    }

    public function factory(){
        return $this->hasOne(Factory::class,'id','factory_id');
    }
}
