<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApprovalDocList extends Model
{
    use HasFactory;
    protected $fillable=[
        'doc_id',
        'chemical_id',
        'conc',
        'conc_low',
        'conc_up',
        'storage',
        'type_storage',
        'type_buy',
        'type_use',
        'type_make',
        'type_sell',
        'type_shift_in',
        'type_shift_out',
        'type_export',
        'type_import',
        'type_decant',
        'type_transfer',
        'type_disposal',
        'type_residual',
        'type_inventory_plus',
        'purpose',
        'start_date',
        'end_date',
        'company_id',
        'created_user',
        'updated_user'
    ];

    public function chemical(){
        return $this->hasOne(Chemical::class,'id','chemical_id');
    }

    public function factory(){
        return $this->hasOne(factory::class,'id','storage');
    }
    public function doc(){
        return $this->belongsTo(ApprovalDoc::class,'doc_id','id');
    }
}
