<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chemical extends Model
{
    use HasFactory;
    protected $fillable = [
        'id',
        'cas_no',
        'ch_name',
        'en_name',
        'hazards',
        'priority',
        'list_priority',
        'control',
        'pioneer',
        'water_poll',
        'list_concerned',
        'concerned',
        'toxic_moenv',
        'listNo',
        'toxic_class',
        'conc',
        'graded',
        'boil',
        'melt',
        'formula',
        'molecular',
        'ingredient',
        'pub_hazard',
        'solv',
        'monitor',
        'chem_spec',
        'lead',
        'four_lead',
        'ccd_health',
        'expose_conc',
        'pel_solide',
        'pel_liquid',
        'a201',
        'a202',
        'a203',
        'a204',
        'a205',
        'a206',
        'a207',
        'a208',
        'a209',
        'a210',
        'a211',
        'a212',
        'a213',
        'a214',
        'a215',
        'a216',
        'a217',
        'a217a',
        'a217b',
        'a217c',
        'a218',
        'a219',
        'a220',
        'a221',
        'a222',
        'a223',
        'a224a',
        'a224b',
        'a225',
        'a225a',
        'a226',
        'a226a',
        'a227',
        'a228',
        'a229',
        'updated_user',
        'transport_icon',
        'danger',
        'danger_volume',
        'danger_unit',
        'danger_name',
        'danger_class',
        'danger_water'
    ];

    protected $dates = ['created_at', 'updated_at'];

    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d'); 
    }
    
    protected static function boot(){
        parent::boot();

        static::saving(function ($model) {
            foreach ($model->attributes as $key => $value) {
                if (is_null($value) && !in_array($key, ['created_at', 'updated_at','created_user','updated_user'])) {
                    $model->setAttribute($key, '');
                }
            }
        });
    }

    public function SdsBase()
    {
        return $this->hasMany(Chemical_sds::class,'chemical_id');
    }

    public function ChemicalReview(){
        return $this->hasOne(Chemical_review::class,'cas_no','cas_no');
    }

}
