<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chemical_operation extends Model
{
    use HasFactory;

    protected $fillable = [
        'factory_chemical_id',
        'serial_num',
        'chemical_id',
        'cas_no',
        'custodian',
        'supplier_id',
        'state',
        'conc',
        'level',
        'brand',
        'weight',
        'type',
        'remark',
        'factory_id',
        'build_id',
        'area_id',
        'company_id',
        'created_user',
        'updated_user',
        'operate_date',
    ];

    public function cas_no()
    {
        return $this->hasOne(Chemical::class, 'id', 'chemical_id');
    }
    public function fact_chem(){
        return $this->hasOne(Factory_chemical::class,'id','factory_chemical_id');
    }
    public function area()
    {
        return $this->hasOne(Factory_area::class, 'id', 'area_id');
    }
    public function build()
    {
        return $this->hasOne(Factory_bding::class, 'id', 'build_id');
    }
    public function factories()
    {
        return $this->hasOne(Factory::class, 'id', 'factory_id');
    }
    public function custodian()
    {
        return $this->hasOne(User::class, 'id', 'custodian');
    }
    public function updated_user()
    {
        return $this->hasOne(User::class, 'id', 'updated_user');
    }
    public function supply()
    {
        return $this->hasOne(Supply::class, 'id', 'supplier_id');
    }
    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    // 自動轉換 weight 為浮點數
    protected $casts = [
        'weight' => 'float',
    ];

    // Accessor: 自動格式化 weight
    public function getWeightAttribute($value)
    {
        return rtrim(rtrim($value, '0'), '.');
    }
}
