<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chemical_ord extends Model
{
    use HasFactory;

    protected $fillable = [
        'bottle_type',
        'add_date',
        'chemical_name',
        'chemical_other',
        'unit',
        'ord_type',
        'custodian',
        'ship_no',
        'supplier_id',
        'chemical_id',
        'cas_no',
        'state',
        'conc',
        'level',
        'brand',
        'weight',
        'bottleCount',
        'packag_unit',
        'remark',
        'use_factory',
        'use_build',
        'use_area',
        'use_avg',
        'use_max',
        'use_user',
        'factory_id',
        'build_id',
        'area_id',
        'store_avg',
        'store_max',
        'company_id',
        'created_user',
        'updated_user',
    ];
    public function factoryChem()
    {
        return $this->hasMany(Factory_chemical::class,'ord_id','id');
    }
    public function chemMix()
    {
        return $this->hasMany(Chemical_mix::class,'ord_id','id');
    }
    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function doc_list(){
        return $this->hasOne(ApprovalDocList::class,'chemical_id','chemical_id');
    }

    public function chemical()
    {
        return $this->hasOne(Chemical::class,'id','chemical_id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (is_null($model->bottle_type)) {
                $model->bottle_type = 0;
            }
            if (is_null($model->chemical_id)) {
                $model->chemical_id = 0;
            }
            if (is_null($model->conc)) {
                $model->conc = 0;
            }
        });
    }
}
