<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chemical_ord_log extends Model
{
    use HasFactory;

    protected $fillable = [
        'ord_id',
        'chemical_id',
        'add_date',
        'cas_no',
        'custodian',
        'supplier_id',
        'state',
        'conc',
        'level',
        'brand',
        'bottleCount',
        'weight',
        'type',
        'remark',
        'factory_id',
        'build_id',
        'area_id',
        'company_id',
        'created_user',
        'updated_user',
    ];

    public function cas_no()
    {
        return $this->hasOne(Chemical::class,'id','chemical_id');
    }
    public function chemical_ord(){
        return $this->hasOne(Chemical_ord::class,'id','ord_id');
    }
    public function area()
    {
        return $this->hasOne(Factory_area::class,'id','area_id');
    }
    public function build()
    {
        return $this->hasOne(Factory_bding::class,'id','build_id');
    }
    public function factories()
    {
        return $this->hasOne(Factory::class,'id','factory_id');
    }
    public function custodian()
    {
        return $this->hasOne(User::class,'id','custodian');
    }
    public function updated_user()
    {
        return $this->hasOne(User::class,'id','updated_user');
    }
    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
    public function getWeightAttribute($value)
    {
        return rtrim(rtrim($value, '0'), '.');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (is_null($model->chemical_id)) {
                $model->chemical_id = 0;
            }
            if (is_null($model->conc)) {
                $model->conc = 0;
            }
        });
    }
}
