<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chemical_residual_log extends Model
{
    use HasFactory;
    protected $fillable=[
        'operate_date',
        'serial_num',
        'factory_chemical_id',
        'custodian',
        'supplier_id',
        'chemical_id',
        'cas_no',
        'state',
        'conc',
        'level',
        'brand',
        'weight',
        'type',
        'remark',
        'factory_id',
        'build_id',
        'area_id',
        'company_id',
        'created_user',
        'updated_user',
    ];

    public function cas_no()
    {
        return $this->hasOne(Chemical::class,'id','chemical_id');
    }
    public function area()
    {
        return $this->hasOne(Factory_area::class,'id','area_id');
    }
    public function build()
    {
        return $this->hasOne(Factory_bding::class,'id','build_id');
    }
    public function factories()
    {
        return $this->hasOne(Factory::class,'id','factory_id');
    }
    public function custodian()
    {
        return $this->hasOne(User::class,'id','custodian');
    }
    public function updated_user()
    {
        return $this->hasOne(User::class,'id','updated_user');
    }
    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
    public function getWeightAttribute($value)
    {
        return rtrim(rtrim($value, '0'), '.');
    }
}
