<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Chemical_review extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $table = 'chemical_reviews';
    protected $fillable = [
        'id',
        'review',
        'cas_no',
        'ch_name'=> '',
        'en_name',
        'created_user',
        'hazards',
        'priority',
        'list_priority',
        'control',
        'pioneer',
        'water_poll',
        'list_concerned',
        'concerned',
        'toxic_moenv',
        'listNo',
        'toxic_class',
        'conc'=> '',
        'graded'=> '',
        'boil'=> '',
        'melt'=> '',
        'formula'=> '',
        'molecular'=> '',
        'ingredient'=> '',
        'pub_hazard',
        'solv',
        'monitor',
        'chem_spec',
        'lead',
        'four_lead',
        'ccd_health',
        'expose_conc',
        'pel_solide'=> '',
        'pel_liquid'=> '',
        'a201',
        'a202',
        'a203',
        'a204',
        'a205',
        'a206',
        'a207',
        'a208',
        'a209',
        'a210',
        'a211',
        'a212',
        'a213',
        'a214',
        'a215',
        'a216',
        'a217',
        'a217a',
        'a217b',
        'a217c',
        'a218',
        'a219',
        'a220',
        'a221',
        'a222',
        'a223',
        'a224a',
        'a224b',
        'a225',
        'a225a',
        'a226',
        'a226a',
        'a227',
        'a228',
        'a229',
        'transport_icon',
        'company_id',
        'updated_user',
        'deleted_at',
        'danger',
        'danger_volume',
        'danger_unit',
        'danger_name',
        'danger_class',
        'danger_water'
    ];

    protected $dates = ['created_at', 'updated_at'];

    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d'); 
    }

    protected static function boot(){
        parent::boot();

        static::saving(function ($model) {
            foreach ($model->attributes as $key => $value) {
                if (is_null($value) && !in_array($key, ['created_at', 'updated_at','company_id','deleted_at','updated_user'])) {
                    $model->setAttribute($key, '');
                }
            }
        });
    }

    // public function getAttribute($key)
    // {
    //     $value = parent::getAttribute($key);

    //     return $value === null ? '' : $value;
    // }

    public function SDSReview()
    {
        return $this->hasMany(Chemical_review_sds::class,'chemical_id');
    }

    public function User()
    {
        return $this->belongsTo(User::class,'created_user','id');
        
    }
}
