<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Factory_chemical extends Model
{
    use HasFactory;

    protected $fillable = [
        'ord_id',
        'serial_num',
        'chemical_name',
        'chemical_other',
        'parent_id',
        'chemical_id',
        'cas_no',
        'custodian',
        'state',
        'conc',
        'level',
        'now_weight',
        'ori_weight',
        'expired_date',
        'factory_id',
        'build_id',
        'area_id',
        'company_id',
        'created_user',
        'updated_user',
        'deleted_at'
    ];

    public function chemical()
    {
        return $this->hasOne(Chemical::class,'id','chemical_id');
    }
    public function area(){
        return $this->hasOne(Factory_area::class,'id','area_id');
    }
    public function chemical_ord(){
        return $this->hasOne(Chemical_ord::class,'id','ord_id');
    }
    public function build(){
        return $this->hasOne(Factory_bding::class,'id','build_id');
    }
    public function factories(){
        return $this->hasOne(Factory::class,'id','factory_id');
    }
    public function custodian(){
        return $this->hasOne(User::class,'id','custodian');
    }
    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function doc_list(){
        return $this->hasOne(ApprovalDocList::class,'chemical_id','chemical_id');
    }

    public function getOriWeightAttribute($value)
    {
        return rtrim(rtrim($value, '0'), '.');
    }

    public function getNowWeightAttribute($value)
    {
        return rtrim(rtrim($value, '0'), '.');
    }
}
