<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    
    use HasFactory;
    

    protected $fillable = [
        'id',
        'uuid',
        'email',
        'name',
        'contact_name',
        'phone',
        'tax_number',
        'role',
        'belongs_parent',
        'expiry_date',
        'password'
    ];


    // protected static function booted()
    // {
    //     static::creating(function ($user) {
    //         if (is_null($user->uuid)) {
    //             $user->uuid = (string) Str::uuid();
    //         }
    //     });
    // }

    // public function items()
    // {
    //     return $this->hasMany(Item::class, 'company_uuid', 'uuid');
    // }
    //一個公司有一個父公司
    public function parent()
    {
        return $this->belongsTo(User::class, 'belongs_parent', 'id');
    }
    //一個公司有多個子公司
    public function children()
    {
        return $this->hasMany(User::class, 'belongs_parent', 'id');
    }
    //一個公司有多個Auditor
    public function auditors()
    {
        return $this->hasMany(User::class, 'belongs_parent', 'uuid')->where('role', 'auditor');
    }
    //一個公司有多個checker
    public function checkers()
    {
        return $this->hasMany(User::class, 'belongs_parent', 'uuid')->where('role', 'checker');
    }

    public function basedata()
    {
        return $this->hasMany(Chemical_review::class,'created_user','id');
    }
}
