<?php

namespace Database\Factories;

use App\Helpers\UserHelper;
use App\Models\Chemical;
use App\Models\Chemical_ord;
use App\Models\Factory as ModelsFactory;
use App\Models\Factory_area;
use App\Models\Factory_bding;
use App\Models\Supply;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Chemical_ord>
 */
class Chemical_ordFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = Chemical_ord::class;

    public function definition(): array
    {
        $chemical = Chemical::inRandomOrder()->first();
        $user = User::whereBetween('id', [2, 12])->inRandomOrder()->first();
        $company_id = $user->role === 'company' ? $user->id : $user->belongs_parent;
        $factory = ModelsFactory::where(
            $user->role === 'company' ? 'company_id' : 'created_user',
            $user->role === 'company' ? $company_id : $user->id
        )
            ->inRandomOrder()
            ->first();
        $factoryBding = Factory_bding::where('f_id', $factory->id)->inRandomOrder()->first(); // 根據工廠 ID 隨機選擇一個工廠大樓
        $factoryArea = Factory_area::where('b_id', $factoryBding->id)->inRandomOrder()->first(); // 根據工廠大樓 ID 隨機選擇一個工廠區域
        $sup = Supply::where('c_id', 2)->inRandomOrder()->first();
        return [
            'bottle_type' => $this->faker->randomElement(['C', 'B']),
            'add_date' => $this->faker->dateTimeBetween('2024-11-01', '2024-12-10')->format('Y-m-d'),
            'ord_type' => $this->faker->randomElement(['J', 'A', 'K', 'C']),
            'custodian' => $user->id,
            'ship_no' => $this->faker->unique()->numberBetween(1000, 9999),
            'supplier_id' => $sup->id,
            'chemical_id' => $chemical->id,  // 假設 chemical_id 是 Chemical 表的 ID
            'cas_no' => $chemical->cas_no,  // 取得化學品的 cas_no
            'state' => $this->faker->randomElement(['s', 'l', 'g']),
            'conc' => $this->faker->randomFloat(2, 1, 100),
            'level' => $this->faker->randomElement(['R', 'I']),
            'brand' => $this->faker->company,
            'weight' => $this->faker->randomFloat(8, 1, 100),
            'bottleCount' => $this->faker->numberBetween(1, 5),
            'remark' => $this->faker->sentence,
            'factory_id' => $factory->id,  // 從 Factory 表中選擇
            'build_id' => $factoryBding->id, // 從 Factory_bding 表中選擇
            'area_id' => $factoryArea->id,  // 從 Factory_area 表中選擇
            'company_id' => $company_id,
            'created_user' => $user->id,
            'updated_user' => $user->id,
        ];
    }
}
