<?php

namespace Database\Factories;

use App\Helpers\UserHelper;
use App\Models\User;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Factory>
 */
class FactoryFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $json = File::get(storage_path('TwCities.json'));
        $cities = json_decode($json, true);  // 將 JSON 轉換為 PHP 陣列

        // 隨機選擇一個城市
        $city = $this->faker->randomElement($cities);

        // 隨機選擇一個區域
        $district = $this->faker->randomElement($city['districts']);
        $user = User::whereBetween('id', [2, 12])->inRandomOrder()->first();
        if($user->role==='company'){
            $company_id = $user->id;
        }else{
            $company_id = $user->belongs_parent;
        }
        return [
            'name' => $this->faker->companyPrefix.'廠',
            'company_id' => $company_id,
            'city' => $this->faker->city,
            'city' => $city['name'],            
            'city_area' => $district['name'],
            'city_address'=>$this->faker->streetAddress(),   
            'updated_user' => $user->id,
            'created_user' => $user->id, 
            'phone'=> $this->faker->numerify('(0#) ####-####'),
            'venderNo'=>strtoupper($this->faker->randomLetter()) . $this->faker->numberBetween(1000000, 9999999),          
        ];
    }
}
