<?php

namespace Database\Factories;

use App\Models\Supply;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\suppliers>
 */
class SupplyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = Supply::class;

    public function definition(): array
    {
        $user = User::whereBetween('id', [2, 12])->inRandomOrder()->first();
        if($user->role==='company'){
            $company_id = $user->id;
        }else{
            $company_id = $user->belongs_parent;
        }
        return [
            'c_id' => $company_id,  
            'created_user' => $user->id,
            'name' => $this->faker->company,
            'No' => $this->faker->unique()->numerify('COMP-####'),
            'country' => $this->faker->randomElement(['國內', '國外']),  // 只有 TW 或 F
            'address' => $this->faker->address,
            'PIC' => $this->faker->name,
            'POC' => $this->faker->name,
            'tel' => $this->faker->phoneNumber, 
            'fax' => $this->faker->phoneNumber,
            'email' => $this->faker->unique()->companyEmail,
            'tax' => $this->faker->regexify('[0-9]{8}'),
            'updated_user' => $user ? $user->id : null, // updated_user 與 created_user 一樣
        ];
    }
}
