<?php

namespace Database\Factories;

use App\Models\Chemical;
use Illuminate\Database\Eloquent\Factories\Factory;

class TestupFactory extends Factory
{
    protected $model = Chemical::class;

    public function definition()
    {
        $chfaker = \Faker\Factory::create('zh_TW');
        $fields = [
            'a201' => $this->faker->numberBetween(0, 1),
            'a202' => $this->faker->numberBetween(0, 1),
            'a203' => $this->faker->numberBetween(0, 1),
            'a204' => $this->faker->numberBetween(0, 1),
            'a205' => $this->faker->numberBetween(0, 1),
            'a206' => $this->faker->numberBetween(0, 1),
            'a207' => $this->faker->numberBetween(0, 1),
            'a208' => $this->faker->numberBetween(0, 1),
            'a209' => $this->faker->numberBetween(0, 1),
            'a210' => $this->faker->numberBetween(0, 1),
            'a211' => $this->faker->numberBetween(0, 1),
            'a212' => $this->faker->numberBetween(0, 1),
            'a213' => $this->faker->numberBetween(0, 1),
            'a214' => $this->faker->numberBetween(0, 1),
            'a215' => $this->faker->numberBetween(0, 1),
            'a216' => $this->faker->numberBetween(0, 1),
            'a217' => $this->faker->numberBetween(0, 1),
            'a217a' => $this->faker->numberBetween(0, 1),
            'a217b' => $this->faker->numberBetween(0, 1),
            'a217c' => $this->faker->numberBetween(0, 1),
            'a218' => $this->faker->numberBetween(0, 1),
            'a219' => $this->faker->numberBetween(0, 1),
            'a220' => $this->faker->numberBetween(0, 1),
            'a221' => $this->faker->numberBetween(0, 1),
            'a222' => $this->faker->numberBetween(0, 1),
            'a223' => $this->faker->numberBetween(0, 1),
            'a224a' => $this->faker->numberBetween(0, 1),
            'a224b' => $this->faker->numberBetween(0, 1),
            'a225' => $this->faker->numberBetween(0, 1),
            'a225a' => $this->faker->numberBetween(0, 1),
            'a226' => $this->faker->numberBetween(0, 1),
            'a226a' => $this->faker->numberBetween(0, 1),
            'a227' => $this->faker->numberBetween(0, 1),
            'a228' => $this->faker->numberBetween(0, 1),
            'a229' => $this->faker->numberBetween(0, 1),
        ];
        $randomKey = array_rand($fields);
        $fields[$randomKey] = $this->faker->randomElement([0, 1]);
        return array_merge([
            'cas_no' => $this->faker->unique()->numerify('###-##-######'),
            'ch_name' => $chfaker->word,
            'en_name' => $this->faker->word,
            'created_user' => $this->faker->numberBetween(1, 5),
            'hazards' => $this->faker->numberBetween(0, 1),
            'priority' => $this->faker->numberBetween(0, 1),
            'list_priority' => $this->faker->regexify('[01]{4}'),
            'control' => $this->faker->numberBetween(0, 1),
            'pioneer' => $this->faker->numberBetween(0, 1),
            'water_poll' => $this->faker->numberBetween(0, 1),
            'list_concerned' => $this->faker->numberBetween(0, 1),
            'concerned' => $this->faker->numberBetween(0, 1),
            'toxic_moenv' => $this->faker->numberBetween(0, 1),
            'listNo' => $this->faker->numberBetween(0, 10000),
            'toxic_class' => $this->faker->regexify('[01]{4}'),
            'conc' => $this->faker->randomFloat(2, 0, 100),
            'graded' => $this->faker->randomFloat(2, 0, 1000),
            'boil' => $this->faker->randomFloat(2, 0, 1000),
            'melt' => $this->faker->randomFloat(2, 0, 1000),
            'formula' => $this->faker->word,
            'molecular' => $this->faker->randomFloat(2, 0, 1000),
            'ingredient' => $this->faker->sentence,
            'pub_hazard' => $this->faker->numberBetween(0, 1),
            'solv' => $this->faker->numberBetween(0, 1),
            'monitor' => $this->faker->numberBetween(0, 1),
            'chem_spec' => $this->faker->numberBetween(0, 1),
            'lead' => $this->faker->numberBetween(0, 1),
            'four_lead' => $this->faker->numberBetween(0, 1),
            'ccd_health' => $this->faker->numberBetween(0, 1),
            'expose_conc' => $this->faker->numberBetween(0, 1),
            'pel_solide' => $this->faker->randomFloat(2, 0, 100),
            'pel_liquid' => $this->faker->randomFloat(2, 0, 100),
            'transport_icon' => $this->faker->regexify('[01]{23}'),
            'company_id' => $this->faker->numberBetween(1, 5),
        ],$fields);
    }
}
