<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chemical_reviews', function (Blueprint $table) {
            $table->id();
            //加入建檔者
            $table->string('review');
            $table->integer('created_user');
            $table->integer('company_id')->nullable();
            //化學品基本信息
            $table->string('cas_no');
            //化學品中文名稱
            $table->string('ch_name')->nullable();
            //化學品英文名稱
            $table->string('en_name');
            //勞動部公告之管制性化學品
            $table->string('hazards');
            //勞動部公告之優先管理化學品
            $table->string('priority');
            $table->string('list_priority')->nullable();
            //勞動部公告之管制性化學品
            $table->string('control');
            //經濟部公告之先驅化學品
            $table->string('pioneer');
            //水質污染化學品
            $table->string('water_poll');
            //環保署公告之關注化學品
            $table->string('concerned');
            $table->string('list_concerned')->nullable();
            //環保署公告之毒化學品
            $table->string('toxic_moenv');
            //列管編號-序號
            $table->string('listNo')->nullable();
            //毒性分類
            $table->string('toxic_class')->nullable();
            //管制濃度(%)
            $table->string('conc')->nullable();
            //分級運作量kg
            $table->string('graded')->nullable();
            //沸點
            $table->string('boil')->nullable();
            //熔點
            $table->string('melt')->nullable();
            //化學式
            $table->string('formula')->nullable();
            //分子量
            $table->string('molecular')->nullable();
            //成分
            $table->text('ingredient')->nullable();
            //公共危險品
            $table->string('pub_hazard');
            //有機溶劑
            $table->string('solv');
            //環境監測
            $table->string('monitor');
            //特定化學物質
            $table->string('chem_spec');
            //鉛
            $table->string('lead');
            //四烷基鉛
            $table->string('four_lead');
            //CCD健康危害
            $table->string('ccd_health');
            //具容許暴露濃度標準
            $table->string('expose_conc');
            //PEL暴露濃度標準值
            $table->string('pel_solide')->nullable(); //固態
            $table->string('pel_liquid')->nullable(); //液態
            //GHS健康危害分類
            $table->string('a201')->nullable(); //爆炸性  
            $table->string('a202')->nullable(); //易燃氣體
            $table->string('a203')->nullable(); //易燃氣溶膠
            $table->string('a204')->nullable(); //氧化性氣體
            $table->string('a205')->nullable(); //加壓氣體
            $table->string('a206')->nullable(); //易燃液體
            $table->string('a207')->nullable(); //易燃固體
            $table->string('a208')->nullable(); //自反應性物質
            $table->string('a209')->nullable(); //發火液體
            $table->string('a210')->nullable(); //發火固體
            $table->string('a211')->nullable(); //自熱物質
            $table->string('a212')->nullable(); //禁水性物質和混合物
            $table->string('a213')->nullable(); //氧化性液體
            $table->string('a214')->nullable(); //氧化性固體
            $table->string('a215')->nullable(); //有機過氧化物
            $table->string('a216')->nullable(); //金屬腐蝕
            $table->string('a217')->nullable(); //急性毒性物體
            $table->string('a217a')->nullable(); //急性毒性物體-經口
            $table->string('a217b')->nullable(); //急性毒性物體-皮膚
            $table->string('a217c')->nullable(); //急性毒性物體-吸入
            $table->string('a218')->nullable(); //皮膚腐蝕/刺激物質
            $table->string('a219')->nullable(); //嚴重損傷/眼睛損害
            $table->string('a220')->nullable(); //呼吸道過敏物質
            $table->string('a221')->nullable(); //皮膚過敏物質  
            $table->string('a222')->nullable(); //生殖細胞致突變性物質
            $table->string('a223')->nullable(); //致癌物質
            $table->string('a224a')->nullable(); //生殖毒性
            $table->string('a224b')->nullable(); //影響哺乳期或通過哺乳期產生影響
            $table->string('a225')->nullable(); //特定標的器官毒性物質~單一暴露
            $table->string('a225a')->nullable(); //特定標的器官毒性物質~單一暴露~皮膚
            $table->string('a226')->nullable(); //特定標的器官毒性物質~重複暴露
            $table->string('a226a')->nullable(); //特定標的器官毒性物質~重複暴露~皮膚
            $table->string('a227')->nullable(); //吸入危害物質
            $table->string('a228')->nullable(); //水環境之危險物質急性
            $table->string('a229')->nullable(); //水環境之危險物質慢性
            //九大類運輸圖示
            $table->string('transport_icon')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chemical_reviews');
    }
};
