<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('factory_areas', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('f_id');
            $table->integer('b_id');
            $table->integer('created_user');
            $table->integer('company_id')->nullable();
            $table->string('floor')->nullable();
            $table->string('pic')->nullable();
            $table->string('pic_path')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('factory_areas');
    }
};
