<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplies', function (Blueprint $table) {
            $table->id();
            //公司ID
            $table->integer('c_id');
            //建立者
            $table->integer('created_user');
            //廠商國家代碼
            $table->string('country')->nullable();
            //合作廠商管編
            $table->string('No')->nullable();
            //合作廠商名稱
            $table->string('name');
            //廠商統編
            $table->string('tax');
            //地址
            $table->string('address')->nullable();
            //負責人
            $table->string('PIC')->nullable();
            //聯絡人
            $table->string('POC')->nullable();
            //電話
            $table->string('tel')->nullable();
            //傳真
            $table->string('fax')->nullable();
            //email
            $table->string('email')->nullable();
            $table->integer('updated_user')->nullable();
            //販賣證號
            //列管編號
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplies');
    }
};
