<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chemical_ords', function (Blueprint $table) {
            $table->id();
            $table->string('bottle_type');
            $table->date('add_date');
            $table->string('ord_type');
            $table->integer('custodian'); //保管人
            $table->string('ship_no')->nullable(); //運輸
            $table->integer('supplier_id')->nullable(); //統編
            $table->integer('chemical_id');
            $table->string('cas_no'); 
            $table->string('state');
            $table->string('conc'); //濃度
            $table->string('level'); 
            $table->string('brand')->nullable();
            $table->decimal('weight',10,3);
            $table->integer('bottleCount');
            $table->string('remark')->nullable();
            $table->integer('factory_id');
            $table->integer('build_id');
            $table->integer('area_id');
            $table->integer('company_id');
            $table->integer('created_user');
            $table->integer('updated_user');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chemical_ords');
    }
};
