<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('factory_chemicals', function (Blueprint $table) {
            $table->id();
            $table->integer('ord_id');
            $table->integer('parent_id')->nullable(); //從哪個化學品分裝
            $table->string('serial_num'); //批次編號
            $table->integer('chemical_id');
            $table->string('cas_no');
            $table->integer('custodian'); //保管人
            $table->string('state');
            $table->string('conc');
            $table->string('level');
            $table->decimal('now_weight',10,3); //現在重量
            $table->decimal('ori_weight',10,3); //原始重量
            $table->date('expired_date')->nullable();
            $table->integer('factory_id');
            $table->integer('build_id');
            $table->integer('area_id');
            $table->integer('company_id');
            $table->integer('created_user');
            $table->integer('updated_user');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('factory_chemicals');
    }
};
