<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chemical_operations', function (Blueprint $table) {
            $table->id();
            $table->integer('factory_chemical_id');
            $table->string('serial_num');
            $table->integer('chemical_id');
            $table->string('cas_no');
            $table->integer('custodian');
            $table->string('supplier_id')->nullable();
            $table->string('state');
            $table->string('conc');
            $table->string('level');
            $table->string('brand')->nullable();
            $table->decimal('weight',10,3);
            $table->string('type');
            $table->string('remark');
            $table->integer('factory_id');
            $table->integer('build_id');
            $table->integer('area_id');
            $table->integer('company_id');
            $table->date('operate_date');
            $table->integer('created_user');
            $table->integer('updated_user');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chemical_operations');
    }
};
