<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chemical_sub_logs', function (Blueprint $table) {
            $table->id();
            $table->integer('chemical_operate_id');
            $table->integer('factory_chemical_id');
            $table->string('serial_num');
            $table->integer('chemical_id');
            $table->string('cas_no');
            $table->integer('custodian');
            $table->decimal('ori_weight',10,3);
            $table->decimal('new_weight',10,3);
            $table->string('remark');
            $table->integer('factory_id');
            $table->integer('build_id');
            $table->integer('area_id');
            $table->integer('company_id');
            $table->integer('created_user');
            $table->integer('updated_user');
            $table->date('operate_date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chemical_sub_logs');
    }
};
