<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('approval_doc_lists', function (Blueprint $table) {
            $table->id();
            $table->integer('doc_id');
            $table->integer('chemical_id');
            $table->string('conc')->nullable();
            $table->string('conc_low')->nullable();
            $table->string('conc_up')->nullable();
            $table->string('purpose')->nullable();
            $table->boolean('type_storage')->default(false)->nullable();
            $table->boolean('type_buy')->default(false)->nullable();
            $table->boolean('type_use')->default(false)->nullable();
            $table->boolean('type_make')->default(false)->nullable();
            $table->boolean('type_shift_in')->default(false)->nullable();
            $table->boolean('type_shift_out')->default(false)->nullable();
            $table->boolean('type_export')->default(false)->nullable();
            $table->boolean('type_import')->default(false)->nullable();
            $table->boolean('type_decant')->default(false)->nullable();
            $table->boolean('type_transfer')->default(false)->nullable();
            $table->boolean('type_sell')->default(false)->nullable();
            $table->boolean('type_disposal')->default(false)->nullable();
            $table->boolean('type_residual')->default(false)->nullable();
            $table->boolean('type_inventory_plus')->default(false)->nullable();
            $table->integer('storage');
            $table->integer('company_id');
            $table->integer('created_user');
            $table->integer('updated_user');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('approval_doc_lists');
    }
};
