<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('chemicals', function (Blueprint $table) {
            $table->string('danger')->nullable();
            $table->string('danger_volume')->nullable();
            $table->string('danger_unit')->nullable();
            $table->string('danger_name')->nullable();
            $table->string('danger_class')->nullable();
            $table->string('danger_water')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('chemicals', function (Blueprint $table) {
            $table->dropColumn([
                'danger',
                'danger_volume',
                'danger_name',
                'danger_unit',
                'danger_class',
                'danger_water',
            ]);
        });
    }
};
