<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('chemical_ords', function (Blueprint $table) {
            $table->text('chemical_name')->nullable();
            $table->text('chemical_other')->nullable();
            $table->string('unit',10)->nullable();
            $table->integer('use_factory')->nullable();
            $table->integer('use_build')->nullable();
            $table->integer('use_area')->nullable();
            $table->string('use_avg',20)->nullable();
            $table->string('use_max',20)->nullable();
            $table->string('use_user',20)->nullable();
            $table->string('store_avg',20)->nullable();
            $table->string('store_max',20)->nullable();
            $table->string('packag_unit',10)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chemical_name','chemical_other','unit','use_factory','use_build','use_area','use_avg','use_max','use_user','store_avg','store_max','packag_unit');
    }
};
