<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
                // 補資料（舉例）
                DB::table('chemical_ords')->whereNull('chemical_name')->update(['chemical_name' => '未知化學品']);
                DB::table('chemical_ords')->whereNull('unit')->update(['unit' => 'kg']);
                DB::table('chemical_ords')->whereNull('use_factory')->update(['use_factory' => 0]);
                DB::table('chemical_ords')->whereNull('use_build')->update(['use_build' => 0]);
                DB::table('chemical_ords')->whereNull('use_area')->update(['use_area' => 0]);
                DB::table('chemical_ords')->whereNull('use_avg')->update(['use_avg' => '0']);
                DB::table('chemical_ords')->whereNull('use_max')->update(['use_max' => '0']);
                DB::table('chemical_ords')->whereNull('use_user')->update(['use_user' => '無']);
                DB::table('chemical_ords')->whereNull('store_avg')->update(['store_avg' => '0']);
                DB::table('chemical_ords')->whereNull('store_max')->update(['store_max' => '0']);
                DB::table('chemical_ords')->whereNull('packag_unit')->update(['packag_unit' => '瓶']);
        
                // 設定為 NOT NULL
                Schema::table('chemical_ords', function ($table) {
                    $table->text('chemical_name')->nullable(false)->change();
                    $table->string('unit',10)->nullable(false)->change();
                    $table->integer('use_factory')->nullable(false)->change();
                    $table->integer('use_build')->nullable(false)->change();
                    $table->integer('use_area')->nullable(false)->change();
                    $table->string('use_avg',20)->nullable(false)->change();
                    $table->string('use_max',20)->nullable(false)->change();
                    $table->string('use_user',20)->nullable(false)->change();
                    $table->string('store_avg',20)->nullable(false)->change();
                    $table->string('store_max',20)->nullable(false)->change();
                    $table->string('packag_unit',10)->nullable(false)->change();
                });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('chemical_ords', function ($table) {
            $table->text('chemical_name')->nullable()->change();
            $table->string('unit',10)->nullable()->change();
            $table->integer('use_factory')->nullable()->change();
            $table->integer('use_build')->nullable()->change();
            $table->integer('use_area')->nullable()->change();
            $table->string('use_avg',20)->nullable()->change();
            $table->string('use_max',20)->nullable()->change();
            $table->string('use_user',20)->nullable()->change();
            $table->string('store_avg',20)->nullable()->change();
            $table->string('store_max',20)->nullable()->change();
            $table->string('packag_unit',10)->nullable()->change();
        });
    }
};
