<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {                // 補資料（舉例）
        DB::table('factory_chemicals')->whereNull('chemical_name')->update(['chemical_name' => '未知化學品']);

        // 設定為 NOT NULL
        Schema::table('factory_chemicals', function ($table) {
            $table->text('chemical_name')->nullable(false)->change();
        });//
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('factory_chemicals', function ($table) {
            $table->text('chemical_name')->nullable()->change();
        });
    }
};
