<?php

namespace Database\Seeders;

use App\Models\Chemical;
use App\Models\ChemicalBase;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Foundation\Auth\User;

class ChemiCsvSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // 變更：只在錯誤檢查時使用這個陣列，而不是用來決定是否更新
        $existingCasNos = Chemical::pluck('cas_no')->toArray(); 
        $existingCasNosInFile = [];
        $filePath = storage_path('chemical.csv');
        $errorCsvFile = storage_path('chemicalbase_errors.csv');
        $file = fopen($filePath, 'r');

        $header = fgetcsv($file);
        $header = $this->removeBOM($header);
        $headerIndex = array_flip($header);
        $errorCsv = fopen($errorCsvFile, 'w');
        fputcsv($errorCsv, $header);

        $rowData = [];
        $batchSize = 500; // 設定批次插入大小

        while (($row = fgetcsv($file)) !== false) {

            $casNo = trim($row[$headerIndex['bs_casno']]);
            
            // 修改：只檢查空值和檔案內重複，不再跳過既有資料
            if (empty($casNo) || in_array($casNo, $existingCasNos) || in_array($casNo, $existingCasNosInFile)) {
                $row[] = 'cas_no 空值或檔案內重複';
                fputcsv($errorCsv, $row);
                continue;
            }
            
            $aFields = [
                $row[$headerIndex['bs_a201']],
                $row[$headerIndex['bs_a202']],
                $row[$headerIndex['bs_a203']],
                $row[$headerIndex['bs_a204']],
                $row[$headerIndex['bs_a205']],
                $row[$headerIndex['bs_a206']],
                $row[$headerIndex['bs_a207']],
                $row[$headerIndex['bs_a208']],
                $row[$headerIndex['bs_a209']],
                $row[$headerIndex['bs_a210']],
                $row[$headerIndex['bs_a211']],
                $row[$headerIndex['bs_a212']],
                $row[$headerIndex['bs_a213']],
                $row[$headerIndex['bs_a214']],
                $row[$headerIndex['bs_a215']],
                $row[$headerIndex['bs_a216']],
                $row[$headerIndex['bs_a217']],
                $row[$headerIndex['bs_a217a']],
                $row[$headerIndex['bs_a217b']],
                $row[$headerIndex['bs_a217c']],
                $row[$headerIndex['bs_a218']],
                $row[$headerIndex['bs_a219']],
                $row[$headerIndex['bs_a220a']],
                $row[$headerIndex['bs_a220b']],
                $row[$headerIndex['bs_a221']],
                $row[$headerIndex['bs_a222']],
                $row[$headerIndex['bs_a223a']],
                $row[$headerIndex['bs_a223b']],
                $row[$headerIndex['bs_a224']],
                $row[$headerIndex['bs_a224b']],
                $row[$headerIndex['bs_a225']],
                $row[$headerIndex['bs_a225b']],
                $row[$headerIndex['bs_a226']],
                $row[$headerIndex['bs_a227a']],
                $row[$headerIndex['bs_a227b']],
            ];

            $result = array_filter($aFields, function ($num) {
                return substr_count((string)$num, '1') >= 2;
            });
            if ($result) {
                $row[] = 'GHS複選';
                fputcsv($errorCsv, $row);
                continue;
            }

            $data= [
                'cas_no' => $casNo,
                'ch_name' => trim($row[$headerIndex['bs_cshort']]),
                'en_name' => trim($row[$headerIndex['bs_eshort']]),
                'hazards' => $this->convertYN($row[$headerIndex['bs_risk']]),
                'priority' => $this->convertYN($row[$headerIndex['bs_first']]),
                'list_priority' => $row[$headerIndex['bs_first_extension']],
                'control' => $this->convertYN($row[$headerIndex['bs_control']]),
                'pioneer' => $this->convertYN($row[$headerIndex['bs_env']]),
                'water_poll' => $this->convertYN($row[$headerIndex['bs_isnowater']]),
                'concerned' => $this->convertYN($row[$headerIndex['bs_concern']]),
                'list_concerned' => $row[$headerIndex['bs_concern_extension']],
                'toxic_moenv' => $this->convertYN($row[$headerIndex['bs_poich']]),
                'listNo' => $row[$headerIndex['bs_poichno']],
                'toxic_class' => $row[$headerIndex['bs_poichtype']],
                'conc' => $this->convertNULL($row[$headerIndex['bs_poichthick']]),
                'graded' => $this->convertNULL($row[$headerIndex['bs_maxWeight']]),
                'boil' => $row[$headerIndex['bs_boiling']],
                'melt' => $row[$headerIndex['bs_fusion']],
                'formula' => $row[$headerIndex['bs_molfm']],
                'molecular' => $row[$headerIndex['bs_molecular']],
                'ingredient' => $row[$headerIndex['bs_element']],
                'pub_hazard' => $this->convertYN($row[$headerIndex['bs_danger']]),
                'solv' => $this->convertYN($row[$headerIndex['bs_organic']]),
                'monitor' => $this->convertYN($row[$headerIndex['bs_envmonitor']]),
                'chem_spec' => $this->convertYN($row[$headerIndex['bs_special']]),
                'lead' => $this->convertYN($row[$headerIndex['bs_pb']]),
                'four_lead' => $this->convertYN($row[$headerIndex['bs_pb4']]),
                'ccd_health' => $this->convertYN($row[$headerIndex['bs_ccb']]),
                'expose_conc' => $this->convertYN($row[$headerIndex['bs_expose']]),
                'pel_solide' => $this->convertNULL($row[$headerIndex['bs_pelsolid']]),
                'pel_liquid' => $this->convertNULL($row[$headerIndex['bs_pelliquid']]),
                'a201' => $this->convertBool($row[$headerIndex['bs_a201']]) ?? null,
                'a202' => $this->convertBool($row[$headerIndex['bs_a202']]) ?? null,
                'a203' => $this->convertBool($row[$headerIndex['bs_a203']]) ?? null,
                'a204' => $this->convertBool($row[$headerIndex['bs_a204']]) ?? null,
                'a205' => $this->convertBool($row[$headerIndex['bs_a205']]) ?? null,
                'a206' => $this->convertBool($row[$headerIndex['bs_a206']]) ?? null,
                'a207' => $this->convertBool($row[$headerIndex['bs_a207']]) ?? null,
                'a208' => $this->convertBool($row[$headerIndex['bs_a208']]) ?? null,
                'a209' => $this->convertBool($row[$headerIndex['bs_a209']]) ?? null,
                'a210' => $this->convertBool($row[$headerIndex['bs_a210']]) ?? null,
                'a211' => $this->convertBool($row[$headerIndex['bs_a211']]) ?? null,
                'a212' => $this->convertBool($row[$headerIndex['bs_a212']]) ?? null,
                'a213' => $this->convertBool($row[$headerIndex['bs_a213']]) ?? null,
                'a214' => $this->convertBool($row[$headerIndex['bs_a214']]) ?? null,
                'a215' => $this->convertBool($row[$headerIndex['bs_a215']]) ?? null,
                'a216' => $this->convertBool($row[$headerIndex['bs_a216']]) ?? null,
                'a217' => $this->convertBool($row[$headerIndex['bs_a217']]) ?? null,
                'a217a' => $this->convertBool($row[$headerIndex['bs_a217a']]) ?? null,
                'a217b' => $this->convertBool($row[$headerIndex['bs_a217b']]) ?? null,
                'a217c' => $this->convertBool($row[$headerIndex['bs_a217c']]) ?? null,
                'a218' => $this->convertBool($row[$headerIndex['bs_a218']]) ?? null,
                'a219' => $this->convertBool($row[$headerIndex['bs_a219']]) ?? null,
                'a220' => $this->convertBool($row[$headerIndex['bs_a220a']]) ?? null,
                'a221' => $this->convertBool($row[$headerIndex['bs_a220b']]) ?? null,
                'a222' => $this->convertBool($row[$headerIndex['bs_a221']]) ?? null,
                'a223' => $this->convertBool($row[$headerIndex['bs_a222']]) ?? null,
                'a224a' => $this->convertBool($row[$headerIndex['bs_a223a']]) ?? null,
                'a224b' => $this->convertBool($row[$headerIndex['bs_a223b']]) ?? null,
                'a225' => $this->convertBool($row[$headerIndex['bs_a224']]) ?? null,
                'a225a' => $this->convertBool($row[$headerIndex['bs_a224b']]) ?? null,
                'a226' => $this->convertBool($row[$headerIndex['bs_a225']]) ?? null,
                'a226a' => $this->convertBool($row[$headerIndex['bs_a225b']]) ?? null,
                'a227' => $this->convertBool($row[$headerIndex['bs_a226']]) ?? null,
                'a228' => $this->convertBool($row[$headerIndex['bs_a227a']]) ?? null,
                'a229' => $this->convertBool($row[$headerIndex['bs_a227b']]) ?? null,
                'transport_icon' => $row[$headerIndex['bs_label']] ?? null,
                'danger'=>0,
                'danger_water'=>0
            ];

            $existingCasNosInFile[] = $casNo;
            $rowData[] = $data;
            if (count($rowData) >= $batchSize) {
                Chemical::insert($rowData);
                $rowData = [];
            }
        }

        if (!empty($rowData)) {
            Chemical::insert($rowData);
        }

        fclose($file);
        fclose($errorCsv);
    }
    
    private function convertYN($value)
    {
        return $value === 'Y' ? 1 : ($value === 'N' ? 0 : $value);
    }

    private function convertBool($value)
    {
        $postion = strpos($value, '1');

        if ($postion !== false) {
            return $postion + 1;
        }
        return 0;
    }
    private function convertNULL($value)
    {
        if ($value === 'NULL') {
            return '';
        } else {
            return $value;
        }
    }
    private function removeBOM($header)
    {
        // 檢查是否包含 BOM 字符 (FEFF)
        foreach ($header as &$value) {
            $value = preg_replace('/^\xEF\xBB\xBF/', '', $value); // 移除 BOM
        }
        return $header;
    }
}
